//
// $Id: REGEX.h,v 1.3 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	REGEX.h
//  author: Jon Baker	
//
//	This class uses the REGEX library found at www.REGEX.org for pattern matching. 
//	
//****************************************************************************************//
#ifndef __REGEX_H__
#define __REGEX_H__

#include "Exception.h"

//	required regex include
#include <pcre.h> 

#include <sstream>
#include <string>

using namespace std;

//	The MAXMATCHES constant should be used by any search method to ensure that
//	endless/excessive matching searching doesn't occure. With out some sort of 
//	maximum it is possible to match so many items that the system would run out 
//	ov memory.
#define MAXMATCHES 5000

//****************************************************************************************//
//	Class : REGEX
//	The REGEX class will act as a container for all methods that use the REGEX library 
//****************************************************************************************//

class REGEX  
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	REGEX();
	~REGEX();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	string	EscapeRegexChars(string);
	int		FindFirstRegexChar(const string stringIn);
	int		FindLastRegexChar(const string stringIn);
	void	GetConstantPortion(string patternIn, string delimIn, string *patternOut, string *constOut);
	bool	IsMatch(const char*, const char*);
	string	RemoveExtraSlashes(string);
	void	Reset();

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------	
	bool IsConstant(string);

	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------	
	int matchCount;
};


//	Define a REGEXException
class REGEXException : public Exception
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	REGEXException(string errMsgIn = "", int severity = ERROR_FATAL);
	~REGEXException();
};


#endif
