//
// $Id: AbsFileFinder.h,v 1.4 2005/04/08 20:14:42 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	AbsFileFinder.h
//  author: Jon Baker	
//	
//****************************************************************************************//
#ifndef __ABSFILEFINDER_H__
#define __ABSFILEFINDER_H__

#ifdef WIN32
	#pragma warning(disable:4786)
#endif

#include "Log.h"
#include "Common.h"
#include "Exception.h"
#include "REGEX.h"

#include <string>
#include <vector>

using namespace std;

//****************************************************************************************//
//	Class : FileFinderResult
//	The FileFinderResult class associates a regular expression string with
//  the set of files that matched that regular expression.
//****************************************************************************************//

class FileFinderResult
{
public:
	FileFinderResult(string regex, sVector matchesIn){this->matches = matchesIn;};
	~FileFinderResult();

	string GetRegex(){return regex;};
	sVector GetMatches(){return matches;};

private:
	string regex;
	sVector matches;
};


//	Define a vector for storing FileFinderResult objects
typedef vector < FileFinderResult*, allocator<FileFinderResult*> > ffrVector;


//****************************************************************************************//
//	Class : AbsFileFinder
//	The AbsFileFinder class is an abstract class.
//  This class requires its base classe to implment the FindFile(string regex) function.
//  This function searches a system for files who's path matches the spcified regular
//  expression. This class maintains a cache of regular repressions checked and their
//  resulting matches. Each time a call is made to the Search(string regex) function the
//  cache is checked before the system is scanned. If the regex has been checked before
//  the cached matches are returned otherwise the system is searched and the results are 
//  cached.
//****************************************************************************************//

class AbsFileFinder
{
public:
	// -----------------------------------------------------------------------
	//	Destructor
	// -----------------------------------------------------------------------
	virtual ~AbsFileFinder();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	sVector Search(string regex);

protected:
	// -----------------------------------------------------------------------
	//	Constructor
	// -----------------------------------------------------------------------
	AbsFileFinder();

	// -----------------------------------------------------------------------
	//	Protectected members
	// -----------------------------------------------------------------------
	virtual sVector FindFiles(string regex) = 0;

	// -----------------------------------------------------------------------
	//	Protectected data
	// -----------------------------------------------------------------------
	static ffrVector fileFinderCache;

	REGEX *fileMatcher;
};

//	Define a FileFinderException
class FileFinderException : public Exception
{
	public:

		FileFinderException(string errMsgIn = "", int severity = ERROR_FATAL);
		~FileFinderException();
};

#endif
