//
// $Id: AbsFileFinder.cpp,v 1.3 2005/04/11 20:39:21 mburton Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "AbsFileFinder.h"

// Define the FileFinderResult vector
ffrVector AbsFileFinder::fileFinderCache;


AbsFileFinder::AbsFileFinder()
{
	// -----------------------------------------------------------------------
	//
	//  ABSTRACT
	//
	//	Note that this is a protected constructor
	// -----------------------------------------------------------------------
	fileMatcher = new REGEX();

}

AbsFileFinder::~AbsFileFinder()
{
	// -----------------------------------------------------------------------
	//
	//  ABSTRACT
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  Public Members  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
sVector AbsFileFinder::Search(string regex)
{
	// -----------------------------------------------------------------------
	//
	//  ABSTRACT
	//
	//	Search the file system for files whose path matches the provided regex.
	//  Return a vector of matching file paths. This method calls the 
	//  pure virtual sVector FindFile(string regex) function. 
	// -----------------------------------------------------------------------

	sVector matchingFilePaths;

	// Check cacheand get a ptr to cached results object if found
	FileFinderResult *ffrPtr = NULL;
	ffrVector::iterator ffrIterator;
	for (ffrIterator=fileFinderCache.begin(); ffrIterator!=fileFinderCache.end(); ffrIterator++) {
		FileFinderResult *ffrTmp = (*ffrIterator);
		
		if(ffrTmp->GetRegex().compare(regex) == 0) {
			ffrPtr = ffrTmp;
			break;
		}
	}


	if(ffrPtr != NULL) {
		// return the set of cached file paths
		matchingFilePaths = ffrPtr->GetMatches();
	} else {
		// search for matching file paths
		matchingFilePaths = FindFiles(regex);

		// add matching file paths to the cache
		FileFinderResult *ffr = new FileFinderResult(regex, matchingFilePaths);
		fileFinderCache.push_back(ffr);
	}
	
	return matchingFilePaths;
}

//****************************************************************************************//
//								FileFinderException Class								  //	
//****************************************************************************************//
FileFinderException::FileFinderException(string errMsgIn, int severity) : Exception(errMsgIn, severity)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the error message and then set the severity to ERROR_FATAL. This is 
	//	done with the explicit call to the Exception class constructor that 
	//	takes a single string param.
	//
	// -----------------------------------------------------------------------

}

FileFinderException::~FileFinderException()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	//
	// -----------------------------------------------------------------------

}
