%define name	ovaldi
%define version	4.1.0
%define release	1.2

Summary:	The OVAL definition interpreter checks a system for vulnerabilities described in an XML definition list.
Name:		%{name}
Version:	%{version}
Release:	%{release}
Source0:	http://oval.mitre.org/DontDownload/oval/download/Interpreters.tbz2
Copyright:	GPL
Group:		System/Configuration/Other
BuildRoot:	%{_tmppath}/%{name}-buildroot
Prefix:		%{_prefix}
BuildArchitectures: i386

%description
OVAL, or the Open Vulnerability Assessment Language, describes how
to check a system for vulnerabilities, providing a common human
readable and machine-parseable language to discuss, refine, and test
vulnerability definitions.

This Vulnerability Definition Interpreter checks a system against
vulnerabilities described in the bundled XML definitions file.


To run:

/usr/sbin/ovaldi.sh


%prep
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
%setup -n Interpreters
#%patch -p0

%build
cd project/redhat
make

%install
/bin/mkdir -p $RPM_BUILD_ROOT/usr/sbin
/bin/mkdir -m 700 -p $RPM_BUILD_ROOT/usr/lib/ovaldi
/bin/mkdir -m 700 -p $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/mkdir -m 755 -p $RPM_BUILD_ROOT/usr/share/doc/ovaldi
/bin/mkdir -m 700 -p $RPM_BUILD_ROOT/var/log/ovaldi

/bin/cp project/redhat/Release/ovaldi $RPM_BUILD_ROOT/usr/sbin
/bin/cp project/redhat/ovaldi.sh $RPM_BUILD_ROOT/usr/sbin
/bin/cp project/redhat/libxerces-c.so.26.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
/bin/cp project/redhat/libxalan-c.so.19.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
/bin/cp project/redhat/libxalanMsg.so.19.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
/bin/cp xml/oval-schema.xsd $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/redhat.definitions.xml $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/redhat-system-characteristics-schema.xsd $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/redhat-oval-results-schema.xsd $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/redhat-schema.xsd $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/oval-results-schema.xsd $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/oval-schema.xsd $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/system-characteristics-schema.xsd $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/mapping.xml $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/mapping.xsd $RPM_BUILD_ROOT/usr/share/ovaldi

/bin/cp docs/terms.txt $RPM_BUILD_ROOT/usr/share/doc/ovaldi
/bin/cp docs/README.txt $RPM_BUILD_ROOT/usr/share/doc/ovaldi
/bin/cp docs/version.txt $RPM_BUILD_ROOT/usr/share/doc/ovaldi

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
/bin/rm -fr $RPM_BUILD_ROOT/%{name}

%post
# Add /usr/lib/ovaldi to the end of /etc/ld.so.conf if it's not yet present.
if [ `/bin/egrep -c '^/usr/lib/ovaldi' /etc/ld.so.conf ` -lt 1 ] ; then
        /bin/echo "/usr/lib/ovaldi" >>/etc/ld.so.conf
#	/sbin/ldconfig
fi
/sbin/ldconfig

%preun
if [ $1 = 0 ]; then
    #// Do stuff specific to uninstalls
if [ -e /usr/lib/ovaldi/libxerces-c.so.26 ] ; then
	/bin/rm /usr/lib/ovaldi/libxerces-c.so.26
fi
if [ -e /usr/lib/ovaldi/libxerces-c.so ] ; then
	/bin/rm /usr/lib/ovaldi/libxerces-c.so
fi
if [ -e /usr/lib/ovaldi/libxalan-c.so.19 ] ; then
        /bin/rm /usr/lib/ovaldi/libxalan-c.so.19
fi
if [ -e /usr/lib/ovaldi/libxalan-c.so ] ; then
        /bin/rm /usr/lib/ovaldi/libxalan-c.so
fi
if [ -e /usr/lib/ovaldi/libxalanRMsg.so.19 ] ; then
        /bin/rm /usr/lib/ovaldi/libxalanMsg.so.19
fi
if [ -e /usr/lib/ovaldi/libxalanMsg.so ] ; then
        /bin/rm /usr/lib/ovaldi/libxalanMsg.so
fi

fi

%postun
if [ $1 = 0 ]; then
   # // Do stuff specific to uninstalls
if  [ `/bin/egrep -c '^/usr/lib/ovaldi' /etc/ld.so.conf ` -gt 0 ] ; then
        /bin/egrep -v '^/usr/lib/ovaldi$' /etc/ld.so.conf >/usr/lib/etc.ld.so.conf.uninstalling-oval
        /bin/chown root:root /usr/lib/etc.ld.so.conf.uninstalling-oval
        /bin/chmod 644 /usr/lib/etc.ld.so.conf.uninstalling-oval
        /bin/mv /usr/lib/etc.ld.so.conf.uninstalling-oval /etc/ld.so.conf
fi
/sbin/ldconfig
fi
if [ $1 = 1 ]; then
	/sbin/ldconfig
   # // Do stuff specific to upgrades
fi

#
#/bin/rmdir /usr/lib/ovaldi
#/bin/rmdir /usr/share/ovaldi
#/bin/rmdir /usr/share/doc/ovaldi

%files 
%defattr(-,root,root,0700)
#%doc terms.txt README.txt
#README 
%defattr(-,root,root,0600)
%attr(0700,root,root)  /usr/sbin/ovaldi
%attr(0700,root,root)  /usr/sbin/ovaldi.sh
%attr(0700,root,root)  /var/log/ovaldi
/usr/lib/ovaldi/libxerces-c.so.26.0
/usr/lib/ovaldi/libxalan-c.so.19.0
/usr/lib/ovaldi/libxalanMsg.so.19.0
/usr/share/ovaldi/redhat.definitions.xml
/usr/share/ovaldi/oval-schema.xsd
/usr/share/ovaldi/oval-results-schema.xsd 
/usr/share/ovaldi/redhat-schema.xsd
/usr/share/ovaldi/redhat-oval-results-schema.xsd
/usr/share/ovaldi/redhat-system-characteristics-schema.xsd
/usr/share/ovaldi/system-characteristics-schema.xsd
/usr/share/ovaldi/mapping.xml
/usr/share/ovaldi/mapping.xsd
/usr/share/doc/ovaldi/terms.txt
/usr/share/doc/ovaldi/README.txt
/usr/share/doc/ovaldi/version.txt

%changelog
* Tue Apr 12 2005 Matt Burton <mburton@mitre.org> 4.1.0-1.2
* Added libxalan libraries and new source to RPM

* Tue Feb 22 2005 Matt Burton <mburton@mitre.org> 4.0.0-1.1
* Changed SPEC file to use the 2.6 xerces library

* Thu Jan 20 2005 Jay Beale <jay@bastille-linux.org> 4.0.0-1.0
* Modified RPM for ovaldi 4.0.0's new structure

* Mon Oct 18 2004 Jay Beale <jay@bastille-linux.org> 3.4.0-1.0
* Rebuilt RPM with new source

* Wed Sep 1 2004 Jay Beale <jay@bastille-linux.org> 3.3.0-1.0
* Rebuilt RPM with new source

* Wed Jul 14 2004 Jay Beale <jay@bastille-linux.org> 3.2.0-1.0
* Rebuilt RPM with new source

* Sun Jun 6 2004 Jay Beale <jay@bastille-linux.org> 3.1.0-1.0
- Rebuilt with new locations and such

* Thu May 6 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.3
- Removed xerces libraries symlinking

* Wed Apr 28 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.2
- Updated to new version

* Wed Apr 21 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.1
- Changed oval.xml to definitions.xml

* Mon Apr 19 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.0
- Initial package creation - enjoy!

