#!/bin/bash

###############################################################################
# This wrapper script runs the definition interpreter with good arguments.    #
#									      #
#   by Jay Beale, 4/2004, Copyright Mitre Corporation 			      #
###############################################################################

#
# Get a date of the start of the run, so we can date-stamp the results
# files.
#

DATE=`/bin/date +%F--%T`

#
# Next, run the definition interpreter pointing it to the locations of the
# files it uses.
#

cd /var/log/ovaldi
/usr/sbin/ovaldi -d /var/log/ovaldi/data-$DATE.xml \
		 -o /usr/share/ovaldi/redhat.definitions.xml \
		 -r /var/log/ovaldi/results-$DATE.xml \
		 -p /usr/share/ovaldi/mapping.xml \
		 -m \
		 $1 $2 	 

echo ...
echo Results-related files are stored in /var/log/ovaldi.
echo ...
