-- [Schema]

CREATE TABLE Placeholder (Placeholder VARCHAR(32))
;
INSERT INTO Placeholder VALUES ('Windows_3.0_20041103')
;

CREATE TABLE Windows_AccountPrivileges (
	AccountName						VARCHAR(128),
	AccountDomain					VARCHAR(128),
	AccountSID						VARCHAR(64),
	SeAssignPrimaryTokenPrivilege		      INTEGER,
	SeAuditPrivilege					INTEGER,
	SeBackupPrivilege					INTEGER,
	SeChangeNotifyPrivilege				INTEGER,
	SeCreateGlobalPrivilege				INTEGER,
	SeCreatePagefilePrivilege			INTEGER,
	SeCreatePermanentPrivilege			INTEGER,
	SeCreateTokenPrivilege				INTEGER,
	SeDebugPrivilege					INTEGER,
	SeEnableDelegationPrivilege			INTEGER,
	SeImpersonatePrivilege				INTEGER,
	SeIncreaseBasePriorityPrivilege		INTEGER,
	SeIncreaseQuotaPrivilege			INTEGER,
	SeLoadDriverPrivilege				INTEGER,
	SeLockMemoryPrivilege				INTEGER,
	SeMachineAccountPrivilege			INTEGER,
	SeManageVolumePrivilege				INTEGER,
	SeProfileSingleProcessPrivilege		INTEGER,
	SeRemoteShutdownPrivilege			INTEGER,
	SeRestorePrivilege				INTEGER,
	SeSecurityPrivilege				INTEGER,
	SeShutdownPrivilege				INTEGER,
	SeSyncAgentPrivilege				INTEGER,
	SeSystemEnvironmentPrivilege		      INTEGER,
	SeSystemProfilePrivilege			INTEGER,
	SeSystemtimePrivilege				INTEGER,
	SeTcbPrivilege					INTEGER,
	SeTakeOwnershipPrivilege			INTEGER,
	SeUndockPrivilege					INTEGER,
	SeUnsolicitedInputPrivilege			INTEGER,
	SeBatchLogonRight					INTEGER,
	SeDenyInteractiveLogonRight			INTEGER,
	SeDenyNetworkLogonRight				INTEGER,
	SeDenyBatchLogonRight				INTEGER,
	SeDenyServiceLogonRight				INTEGER,
	SeDenyRemoteInteractiveLogonRight	      INTEGER,
	SeInteractiveLogonRight				INTEGER,
	SeNetworkLogonRight				INTEGER,
	SeRemoteInteractiveLogonRight		      INTEGER,
	SeServiceLogonRight				INTEGER)
;

CREATE TABLE Windows_ActiveDirectory (
	naming_context					VARCHAR(32),
	relative_dn						VARCHAR(128),
	attribute						VARCHAR(128),
	object_class					VARCHAR(128),
	adstype						VARCHAR(32),
	value							VARCHAR(1024))
;

CREATE TABLE Windows_ActiveDirectory_Conf (
	naming_context					VARCHAR(32),
	relative_dn						VARCHAR(128))
;


CREATE TABLE Windows_FileAttributes (
	FilePath						VARCHAR(1024),
	Owner							VARCHAR(128),
	Filesize						INTEGER,
	ATime							INTEGER,
	CTime							INTEGER,
	MTime							INTEGER,
	MSChecksum						VARCHAR(64),
	MD5							VARCHAR(64),
	Version1						INTEGER,
	Version2						INTEGER,
	Version3						INTEGER,
	Version4						INTEGER,
	FileType						VARCHAR(32),
	development_class 				VARCHAR(32))
;

CREATE TABLE Windows_FileAttributes_Conf (FilePath VARCHAR(1024))
;

CREATE TABLE Windows_FileEffectiveRights (
	FilePath						VARCHAR(1024),
	TrusteeName						VARCHAR(128),
	TrusteeDomain					VARCHAR(128),
	TrusteeSID						VARCHAR(64),
	STANDARD_DELETE					INTEGER,
	STANDARD_READ_CONTROL				INTEGER,
	STANDARD_WRITE_DAC				INTEGER,
	STANDARD_WRITE_OWNER				INTEGER,
	STANDARD_SYNCHRONIZE				INTEGER,
	ACCESS_SYSTEM_SECURITY				INTEGER,
	GENERIC_READ					INTEGER,
	GENERIC_WRITE					INTEGER,
	GENERIC_EXECUTE					INTEGER,
	GENERIC_ALL						INTEGER,
	FILE_READ_DATA					INTEGER,
	FILE_WRITE_DATA					INTEGER,
	FILE_APPEND_DATA					INTEGER,
	FILE_READ_EA					INTEGER,
	FILE_WRITE_EA					INTEGER,
	FILE_EXECUTE					INTEGER,
	FILE_DELETE_CHILD					INTEGER,
	FILE_READ_ATTRIBUTES				INTEGER,
	FILE_WRITE_ATTRIBUTES				INTEGER)
;

CREATE TABLE Windows_FileEffectiveRights_Conf (FilePath VARCHAR(1024))
;

CREATE TABLE Windows_MetabaseKeys (
	MetabaseKey						VARCHAR(1024),
	Id							INTEGER,
	Name							VARCHAR(128),
	UserType						VARCHAR(32),
	DataType						VARCHAR(32),
	Data							VARCHAR(128),
	METADATA_NO_ATTRIBUTES				INTEGER,
	METADATA_INHERIT					INTEGER,
	METADATA_PARTIAL_PATH				INTEGER,
	METADATA_SECURE					INTEGER,
	METADATA_REFERENCE				INTEGER,
	METADATA_VOLATILE					INTEGER,
	METADATA_ISINHERITED				INTEGER,
	METADATA_INSERT_PATH				INTEGER,
	METADATA_LOCAL_MACHINE_ONLY			INTEGER)
;

CREATE TABLE Windows_MetabaseKeys_Conf (MetabaseKey VARCHAR(1024))
;

CREATE TABLE Windows_PSInfo (
	PID							INTEGER,
	PPID							INTEGER,
	Priority						INTEGER,
	ImagePath						VARCHAR(1024),
	CommandLine						VARCHAR(1024),
	CurrentDir						VARCHAR(1024))
;


CREATE TABLE Windows_RegistryKeys (
	RegistryKey						VARCHAR(1024),
	EntryName						VARCHAR(128),
	EntryType						VARCHAR(32),
	EntryValue						VARCHAR(1024))
;

CREATE TABLE Windows_RegistryKeys_Conf (RegistryKey VARCHAR(1024))
;

CREATE TABLE Windows_RegKeyEffectiveRights (
	RegistryKey						VARCHAR(1024),
	TrusteeName						VARCHAR(128),
	TrusteeDomain					VARCHAR(128),
	TrusteeSID						VARCHAR(64),
	STANDARD_DELETE					INTEGER,
	STANDARD_READ_CONTROL				INTEGER,
	STANDARD_WRITE_DAC				INTEGER,
	STANDARD_WRITE_OWNER				INTEGER,
	STANDARD_SYNCHRONIZE				INTEGER,
	ACCESS_SYSTEM_SECURITY				INTEGER,
	GENERIC_READ					INTEGER,
	GENERIC_WRITE					INTEGER,
	GENERIC_EXECUTE					INTEGER,
	GENERIC_ALL						INTEGER,
	KEY_QUERY_VALUE					INTEGER,
	KEY_SET_VALUE					INTEGER,
	KEY_CREATE_SUB_KEY				INTEGER,
	KEY_ENUMERATE_SUB_KEYS				INTEGER,
	KEY_NOTIFY						INTEGER,
	KEY_CREATE_LINK                           INTEGER)
;

CREATE TABLE Windows_RegKeyEffectiveRights_Conf (RegistryKey VARCHAR(1024))
;

-- [Conf]

-- ============================================================================
-- Active Directory

-- ============================================================================
-- Registry Keys
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion:LIT|CurrentVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840374:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\DataAccess:LIT|FullInstallVer')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server:LIT|VersionMajor')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\MSExchangeWEB\DAV:LIT|ReuseConnections')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\Fwsrv:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SOFTWARE\\Microsoft\\Fpc\\Arrays\\\{[^\\]+\}\\Extensions\\Proxy-Plugins\\\{FE440D49-AB26-11D2-A101-00C04FB6CFB6\}$:LIT|msFPCEnabled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Exchange Server 2003\SP1\832759:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\DataAccess\Q832483:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB832483:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\291:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Exchange\Setup:LIT|Services Version')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CLASSES_ROOT:LIT|HCP:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1200')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CURRENT_USER:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1200')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1400')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CURRENT_USER:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1400')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Office\9.0\Word\InstallRoot:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Office\10.0\Word\InstallRoot:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Office\9.0\Excel\InstallRoot:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Office\10.0\Excel\InstallRoot:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB832894:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows Media Services\KB832359:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\nsstation:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows Media Services\KB832359:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NetShow:LIT|Version')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\PCT 1.0\Server:LIT|Enabled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Outlook Express\Version Info:LIT|Current')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Internet Explorer:LIT|Version')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB837001:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB837009:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{2cc9d512-6db6-4f1c-8979-9a41fae88de0}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CURRENT_USER:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1001')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CURRENT_USER:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1803')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CURRENT_USER:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1A02')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1A03')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CURRENT_USER:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1A03')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\Netlogon:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Office\10.0\Outlook\InstallRoot:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{90280409-6000-11D3-8CFE-0050048383C9}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\INetStp:LIT|MajorVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\INetStp:LIT|MinorVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion:LIT|CSDVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q326886:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB867801:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows 2000\SP4\Q321599:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q313450:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\SMTPSVC:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q295534:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q299444:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q318593:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q269862:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q277873:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q293826:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\Q331953:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823980:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Ras\CurrentVersion:LIT|PathName')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q318138:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\RasMan:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion:LIT|CurrentVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\MSSQLServer\MSSQLServer:LIT|LoginMode')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q320206:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q314147:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\SNMP:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q311967:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q291845:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1A02')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\URL\Prefixes:LIT|gopher')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q810833:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\RPCLocator:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q815021:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\277:LIT|Kbs')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB817606:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Classes\MIME\Database\Content Type\application/hta:LIT|Extension')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824146:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Ole:LIT|EnableDCOM')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{90A2A715-D986-4EAB-8C73-4D06114EF760}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{754D29C1-0C97-405F-98D0-21B212CA7FF1}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1803')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q312895:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q313829:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q321599:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823182:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\[0-4]$:LIT|1001')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q326830:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\lanmanserver:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q323172:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q300972:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings:LIT|Security_HKLM_only')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\Terminal Server:LIT|ProductVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q324380:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\RDPWD:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824141:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\UtilMan:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\Messenger:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB825119:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Setup\OC Manager\Subcomponents:LIT|fp_extensions')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB826232:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\Q305601:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329170:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\lanmanserver\parameters:LIT|enablesecuritysignature')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\MediaPlayer\8.0\Registration:LIT|UDBVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows Media Player\wm320920:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows Media Player\wm308567:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\5.0\Setup Packages:LIT|Microsoft FrontPage Server Extensions 2002')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q823803:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows Media Player\wm817787:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q303984:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\NntpSvc:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q323255:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\Setup Packages:LIT|FrontPage 2000 Server Extensions SR')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\257:LIT|Kbs')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q307298:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\Tlntsvr:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB822679:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\Setup Packages:LIT|SharePoint')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Active Setup\Installed Components\{A954CDD5-A95F-414F-B3FE-FBEF9D2AECEA}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Active Setup\Installed Components\{754D29C1-0C97-405F-98D0-21B212CA7FF1}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Active Setup\Installed Components\{716E024F-7F74-47F3-B93B-9FF7F3CBF94C}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\DataAccess\Q823718:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Ole:LIT|EnableDCOMHTTP')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q232449 :LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\Hotfix\Q811114:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB817772:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB822343:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion:LIT|Version')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\UtilMan{5c773859-bb96- 48fa-875b-6a58aae072f4}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\NetBIOS\Linkage:LIT|Bind')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\NetBIOS\Linkage:LIT|Export')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\NetBIOS\Linkage:LIT|Route')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\LmHosts:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^SYSTEM\CurrentControlSet\Services\NetBT\Parameters\Interfaces\Tcpip.*$:LIT|NetbiosOptions')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\SecurePipeServers\winreg:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\ProductOptions:LIT|ProductType')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\DirectX:LIT|Version')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643-DirectX82:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643-DirectX9:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\ProductOptions:LIT|ProductSuite')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q265714:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Transaction Server\Packages:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q317636:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:PAT|^Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\.*:LIT|DisplayName')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Updates\Exchange Server 2000\SP3\Q316056:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\SecurePipeServers\winreg:LIT|Everyone')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX8:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX81:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX82:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX9:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\LSA:LIT|RestrictAnonymous')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|\Software\VERITAS\Backup Exec\Server:LIT|CurrentVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows XP\SP1\KB824105\Filelist:LIT|installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Windows XP\SP2\KB824105\Filelist:LIT|installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329115:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811493:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\Session Manager\Subsystem:LIT|Posix')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841872:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB842526:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840315:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB841873:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q841373:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|System\CurrentControlSet\Services\w3svc\parameters:LIT|MaxClientRequestBufferData')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839645:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4395}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Classes\ITSProtocol:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{bfb56e60-5895-496c-bd6b-459b97142e4c}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB821557:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_CLASSES_ROOT:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\kb823353:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_USERS:PAT|^S-[-0-9]+\\Identities\\\{[-0-9A-Z]+\}\\Software\\Microsoft\\Outlook\ Express\\5\.0\\Mail$:LIT|ShowHybridView')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{4f645220-306d-11d2-995d-00c04f98bbc9}:LIT|Version')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q328310:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329414:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Exchange\Setup:LIT|ServicePackBuild')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Exchange Server 5.5\SP5\842436a:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\MSExchangeweb:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB833987:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB833987:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{90110409-6000-11D3-8CFE-0150048383C9}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040110900063D11C8EF10054038389C\Patches\9FEC06657760FC84499ED532196D45EE2:LIT|Security Update for Office 2003: Wordperfect 5.x Converter (KB873378)')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040110900063D11C8EF10054038389C\Patches\FC3FF5BA5FE5D1B4A9B9CD3698A34B89:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Updates\Visual Studio\7.1\M8303481037:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\VisualStudio\7.1:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Windows\CurrentVersion\Uninstall\{903B0409-6000-11D3-8CFE-0150048383C9}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040B30900063D11C\Patches\69B0450262BC7F44E8D4B683A49E437A:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{903B0409-6000-11D3-8CFE-0050048383C9}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040B30900063D11C8EF00054038389C\Patches\1F6752D69ABCD9F4B8021B9163826CAC:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Windows\CurrentVersion\Uninstall\{90510409-6D54-11D4-BEE3-00C04F990354}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040150945D64D11EB3E000CF4993045\Patches\A75085E78F7F14244A464F09F6543C6C:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Windows\CurrentVersion\Uninstall\{90510409-6000-11D3-8CFE-0150048383C9}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040150900063D11C8EF10054038389C\Patches\6B94DD4A71ECBDE43822F9D47D963102:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{00000409-78E1-11D2-B60F-006097C998E7}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Patches\A1334AC428B43BF4E9547C55D3DFE977:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\VisualStudio\7.0:LIT|')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040F50095765D115AF4000972A8B18B\Patches\4A3C9366F1471A7479BB3FDBC1FE3B31:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\9040820900063D11C\Patches\4461EFFBCC9338645A85657DBDEB9E61:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{dc0d5f50-5F0b-46bf-8683-93ac61c67001}:LIT|ComponentID')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{00010409-78E1-11D2-B60F-006097C998E7}:LIT|DisplayVersion')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|Software\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841356:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\W3SVC\Parameters:LIT|DisableWebDAV')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB885881:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840987:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB883935:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824151:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841533:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB873376:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Classes\CompressedFolder:LIT|FriendlyTypeName')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB883935:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB873350:LIT|File')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707-ie501sp3-20040929.121357:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707-ie501sp4-20040929.111451:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Active Setup\Installed Components\{ 3e7bb08a-a7a3-4692-8eac-ac5e7895755b}:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707-ie6-20040929.115007 :LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707:LIT|IsInstalled')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824245:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Control\Session Manager\Environment:LIT|PROCESSOR_ARCHITECTURE')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\lanmanworkstation:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828035:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828749:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB810217:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB830352:LIT|Installed')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SYSTEM\CurrentControlSet\Services\wins:LIT|Start')
;
INSERT INTO Windows_RegistryKeys_Conf (RegistryKey) VALUES ('LIT|HKEY_LOCAL_MACHINE:LIT|SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828028:LIT|Installed')
;

-- ============================================================================
-- Registry Key Rights

-- ============================================================================
-- File Attributes
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server\InstallationLocation:LIT|\w3proxy.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server\InstallationLocation:LIT|\wspsrv.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\itircl.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\itss.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\msasn1.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\wins.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\CommonFilesDir:LIT|\Microsoft Shared\web server extensions\50\bin\fp30reg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\CommonFilesDir:LIT|\Microsoft Shared\web server extensions\40\bin\fp30reg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\CommonFilesDir:LIT|\Microsoft Shared\web server extensions\40\isapi\shtml.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\jscript.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\msgsvc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\OUTLOOK.EXE:LIT|outlook.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\msgina.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\msjet40.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\mf3216.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Excel.exe\Path:LIT|\excel.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\msdxm.ocx')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\wmpcore.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ProgramFilesDir:LIT|\Windows Media Player\wmplayer.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\h323.tsp')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\lsasrv.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe\Path:LIT|\winword.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\schannel.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\comsvcs.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\wmsjet40.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetcomm.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\rpcrt4.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\rpcss.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\wintrust.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\helpctr.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\wkssvc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\mshtml.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\w3svc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\netman.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\ism.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\smtpsvc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\srvsvc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\rasman.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\netlogon.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\asp.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|sqlservr.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\smss.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|ssmsrp70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\snmp.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\drivers\mup.sys')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\httpext.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\Locator.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\ntdll.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\Drivers\SRV.SYS')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|odsole70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\shdocvw.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\shell32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\cryptui.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\xactsrv.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\xenroll.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\idq.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\drivers\rdpwd.sys')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\user32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\tshoot.ocx')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|xpstar.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\dxmasf.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\kernel32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\nntpsvc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\rpcproxy.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\hhctrl.ocx')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\hhsetup.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\tlntsvr.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\sp3res.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\umandlg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\ole32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\ssinc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ProgramFilesDir:LIT|\MSN Messenger\msgsc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\msjava.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\helpctr.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\w3svc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\Msw3prt.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\CommonFilesDir:LIT|\Microsoft Shared\web server extensions\40\bin\fp4areg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\odbcbcp.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\evtgprov.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\CommonFilesDir:LIT|\Microsoft Shared\web server extensions\50\bin\fp5areg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\System32\w3svc.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\InstallDirectory:LIT|h323fltr.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\System32\msw3prt.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\System32\code.asp')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\System32\nsiislog.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\SystemRoot:LIT|\system\vserver.vxd')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup\Services:LIT|\bin\exprox.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\System32\Msw3prt')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\System32\Ntoskrnl.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WindowsNT\CurrentVersion\SystemRoot:LIT|\system32\Ipnathlp.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\System32\Ipnathlp.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\sqlsrv32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\dplayx.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\SysWOW64\dplayx.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\SystemRoot:LIT|\system32\tcpcfg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\SystemRoot:LIT|\system32\winlogon.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup\Services:LIT|\bin\mad.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|sqlservr.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|odsole70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|xpstar.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\SystemRoot:LIT|\system32\dplayx.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|ssnetlib.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|xpqueue.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|xprepl.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|xplog70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe\Path:LIT|xpweb70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\crypt32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\cryptdlg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\Sp3res.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\psxss.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\Umandlg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\mstask.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\Windows Media\Server\nscm.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\drivers\netbt.sys')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\Windows Media\Server\nspmon.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\gdi32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\winsrv.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\win32k.sys')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ProgramFilesDir:LIT|\Common Files\System\msadc\msadco.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office:LIT|\10.0\Common\InstallRoot\msohev.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\cdo.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\D6CE92CC2CB71D1\9040210900063D11C8EF10054038389C')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\:LIT|\System\Ole DB folder\sqlisapi.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\sxs.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\A0A0D0E3C44B1C\9040210900063D11C8EF10054038389C')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\A5052E3053B8D3D')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\dbmslpcn.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\vdmdbg.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\SysWOW64\shell32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\nddenb32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\grpconv.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|ssmslpcn.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\netdde.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\syswow64\shell32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|ssnetlib.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\zipfldr.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\SysWOW64\zipfldr.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|ssnmpn70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\nddenb32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\inetsrv\netdde.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\SysWOW64\nddenb32.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\SysWOW64\netdde.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server\SharedCode:LIT|msgprox.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server\SharedCode:LIT|replrec.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server\SharedCode:LIT|sqlvdi.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|impprov.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot:LIT|\system32\dbmsrpcn.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|xpweb70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|msgprox.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server\SharedCode:LIT|replprov.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|replrec.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|sqlvdi.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|xpqueue.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|xprepl.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|xplog70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|console.exe')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WindowsNT\CurrentVersion\SystemRoot:LIT|\system32\dbmslpcn.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|sqlmap70.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|sqlrepss.dll')
;
INSERT INTO Windows_FileAttributes_Conf (FilePath) VALUES ('REG|HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe\Path:LIT|ums.dll')
;

-- ============================================================================
-- File Rights

-- ============================================================================
-- Metabase
INSERT INTO Windows_MetabaseKeys_Conf (MetabaseKey) VALUES ('LIT|6014')
;
INSERT INTO Windows_MetabaseKeys_Conf (MetabaseKey) VALUES ('LIT|1016')
;
INSERT INTO Windows_MetabaseKeys_Conf (MetabaseKey) VALUES ('LIT|6032')
;
INSERT INTO Windows_MetabaseKeys_Conf (MetabaseKey) VALUES ('LIT|6011')
;
INSERT INTO Windows_MetabaseKeys_Conf (MetabaseKey) VALUES ('LIT|5506')
;


-- [Query]

-- ============================================================================
--
-- OVAL-id: OVAL12
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4913.1100

	(SELECT 'the version of mshtml.dll is less than 5.50.4913.1100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4913 OR Version3 = 4913 AND
		Version4 < 1100))))))

AND NOT EXISTS

	-- the patch q316059 is installed (Installed Components key)

	(SELECT 'the patch q316059 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL16
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0079' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL17
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0023' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2713.1100

	(SELECT 'the version of mshtml.dll is less than 6.0.2713.1100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2713 OR Version3 = 2713 AND
		Version4 < 1100))))))

AND NOT EXISTS

	-- the patch q316059 is installed (Installed Components key)

	(SELECT 'the patch q316059 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL18
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0070' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of shell32.dll is less than 4.0.1381.7116

	(SELECT 'the version of shell32.dll is less than 4.0.1381.7116' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7116))))))

AND NOT EXISTS

	-- Patch Q313829 Installed

	(SELECT 'Patch Q313829 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q313829' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL19
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0189' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2716.2200

	(SELECT 'the version of mshtml.dll is less than 6.0.2716.2200' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2716 OR Version3 = 2716 AND
		Version4 < 2200))))))

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL22
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0147' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL23
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4725.2100

	(SELECT 'the version of mshtml.dll is less than 5.50.4725.2100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4725 OR Version3 = 4725 AND
		Version4 < 2100))))))

AND NOT EXISTS

	-- the patch q316059 is installed (Installed Components key)

	(SELECT 'the patch q316059 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL24
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0073' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FTP Enabled

	(SELECT 'FTP Enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\MSFTPSVC\%' AND
		Id = '1016' AND
		Data != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL25
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0079' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL26
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0720' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

AND EXISTS

	-- the version of netman.dll is less than 5.0.2195.5974

	(SELECT 'the version of netman.dll is less than 5.0.2195.5974' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netman.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5974))))))

AND NOT EXISTS

	-- Patch Q326886 Installed

	(SELECT 'Patch Q326886 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q326886' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL27
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0193' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Installed
	(SELECT 'Internet Explorer 5.01 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.3800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.6307')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2920.0000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3103.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3105.0106')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3314.2101')

	OR EXISTS
		-- Internet Explorer 5.01 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3315.1000'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3504.2500

	(SELECT 'the version of mshtml.dll is less than 5.0.3504.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3504 OR Version3 = 3504 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- SP4 or later Installed

		(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue >= 'Service Pack 4'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL29
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0364' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\ism.dll version is less than 5.0.2195.5671

	(SELECT 'File %windir%\system32\inetsrv\ism.dll version is less than 5.0.2195.5671' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\ism.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5671))))))

AND NOT EXISTS

	-- Patch Q321599 Installed

	(SELECT 'Patch Q321599 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows 2000\SP4\Q321599' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ism.dll mapping exists

	(SELECT 'ism.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ism.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL30
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0055' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\inetsrv\smtpsvc.dll version is less than 5.0.2195.4905

	(SELECT 'File %windir%\system32\inetsrv\smtpsvc.dll version is less than 5.0.2195.4905' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\smtpsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4905))))))

AND NOT EXISTS

	-- Patch Q313450

	(SELECT 'Patch Q313450' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q313450' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SMTP Enabled

	(SELECT 'SMTP Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SMTPSVC' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL32
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2713.1100

	(SELECT 'the version of mshtml.dll is less than 6.0.2713.1100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2713 OR Version3 = 2713 AND
		Version4 < 1100))))))

AND NOT EXISTS

	-- the patch q316059 is installed (Installed Components key)

	(SELECT 'the patch q316059 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL35
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0073' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FTP Enabled

	(SELECT 'FTP Enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\MSFTPSVC\%' AND
		Id = '1016' AND
		Data != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL37
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0333' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- File %windir%\system32\inetsrv\ism.dll version is less than 4.2.764.1

	(SELECT 'File %windir%\system32\inetsrv\ism.dll version is less than 4.2.764.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\ism.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 764 OR Version3 = 764 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q295534 Installed

	(SELECT 'Patch Q295534 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q295534' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows NT 4.0 Security Roll-up Package

	(SELECT 'Windows NT 4.0 Security Roll-up Package' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q299444' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL38
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0051' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (domain controller) is installed
	(SELECT 'Windows 2000 (domain controller) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- this is an NT Server (domain controller)

		(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductType' AND
			EntryValue LIKE '%LanmanNT%'))

AND EXISTS

	-- the version of srvsvc.dll is less than 5.00.2195.4980

	(SELECT 'the version of srvsvc.dll is less than 5.00.2195.4980' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\srvsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4980))))))

AND NOT EXISTS

	-- Patch Q318593 Installed

	(SELECT 'Patch Q318593 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q318593' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL39
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0150' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL40
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0023' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4913.1100

	(SELECT 'the version of mshtml.dll is less than 5.50.4913.1100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4913 OR Version3 = 4913 AND
		Version4 < 1100))))))

AND NOT EXISTS

	-- the patch q316059 is installed (Installed Components key)

	(SELECT 'the patch q316059 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL44
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2000-0884' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\w3svc.dll version is less than 5.0.2195.2103

	(SELECT 'File %windir%\system32\inetsrv\w3svc.dll version is less than 5.0.2195.2103' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 2103))))))

AND NOT EXISTS

	-- Patch Q269862 Installed

	(SELECT 'Patch Q269862 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q269862' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q277873 Installed

	(SELECT 'Patch Q277873 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q277873' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q293826 Installed

	(SELECT 'Patch Q293826 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q293826' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 is installed

	(SELECT 'Win2K/XP/2003 service pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL45
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0071' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ism.dll mapping exists

	(SELECT 'ism.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ism.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL46
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0074' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL49
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-1326' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Installed
	(SELECT 'Internet Explorer 5.01 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.3800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.6307')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2920.0000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3103.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3105.0106')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3314.2101')

	OR EXISTS
		-- Internet Explorer 5.01 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3315.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Service Pack 3 is installed

		(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3502.1000'))

AND EXISTS

	-- File %windir%\system32\mshtml.dll version is less than 5.0.3513.900

	(SELECT 'File %windir%\system32\mshtml.dll version is less than 5.0.3513.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3513 OR Version3 = 3513 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL50
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0023' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Installed
	(SELECT 'Internet Explorer 5.01 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.3800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.6307')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2920.0000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3103.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3105.0106')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3314.2101')

	OR EXISTS
		-- Internet Explorer 5.01 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3315.1000'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3502.4856

	(SELECT 'the version of mshtml.dll is less than 5.0.3502.4856' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3502 OR Version3 = 3502 AND
		Version4 < 4856))))))

AND NOT EXISTS

	-- the patch q316059 is installed (Installed Components key)

	(SELECT 'the patch q316059 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL57
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-1328' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2723.2500

	(SELECT 'the version of mshtml.dll is less than 6.0.2723.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2723 OR Version3 = 2723 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL58
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0075' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL59
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1561' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6106

	(SELECT 'File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6106' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6106))))))

AND NOT EXISTS

	-- Patch Q331953_W2K_SP4_X86_EN.exe Installed

	(SELECT 'Patch Q331953_W2K_SP4_X86_EN.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\Q331953' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Windows2000-KB823980-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB823980-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823980' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL61
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0366' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- RAS Phonebook

	(SELECT 'RAS Phonebook' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ras\CurrentVersion' AND
		EntryName = 'PathName' AND
		EntryValue = 'RASPHONE.PBK')

AND EXISTS

	-- File %windir%\system32\rasapi32.dll version is less than 4.0.1381.7140

	(SELECT 'File %windir%\system32\rasapi32.dll version is less than 4.0.1381.7140' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rasman.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7140))))))

AND NOT EXISTS

	-- Patch Q318138 Installed

	(SELECT 'Patch Q318138 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q318138' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- RAS Enabled

	(SELECT 'RAS Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RasMan' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL63
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0366' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- RAS Phonebook

	(SELECT 'RAS Phonebook' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ras\CurrentVersion' AND
		EntryName = 'PathName' AND
		EntryValue = 'RASPHONE.PBK')

AND EXISTS

	-- File %windir%\system32\rasman.dll version is less than 5.0.2195.4983

	(SELECT 'File %windir%\system32\rasman.dll version is less than 5.0.2195.4983' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rasman.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4983))))))

AND NOT EXISTS

	-- Patch Q318138 Installed

	(SELECT 'Patch Q318138 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q318138' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- RAS Enabled

	(SELECT 'RAS Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RasMan' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL64
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0018' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\netlogon.dll version is less than 5.00.0893.1105

	(SELECT 'File %windir%\system32\netlogon.dll version is less than 5.00.0893.1105' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netlogon.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 893 OR Version3 = 893 AND
		Version4 < 1105))))))

AND NOT EXISTS

	-- Windows 2000 Security Roll-up 1 Installed

	(SELECT 'Windows 2000 Security Roll-up 1 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL66
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0223' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\asp.dll version is less than 5.0.2195.6672

	(SELECT 'File %windir%\system32\inetsrv\asp.dll version is less than 5.0.2195.6672' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\asp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6672))))))

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL71
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0344' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File sqlservr.exe version3 is less than 296

	(SELECT 'File sqlservr.exe version3 is less than 296' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 296 OR Version3 = 296 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Mixed Mode Enabled

	(SELECT 'Mixed Mode Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer' AND
		EntryName = 'LoginMode' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL72
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0147' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL76
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0367' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\smss.exe version is less than 5.0.2195.5695

	(SELECT 'File %windir%\system32\smss.exe version is less than 5.0.2195.5695' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\smss.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5695))))))

AND NOT EXISTS

	-- Patch Q320206 Installed

	(SELECT 'Patch Q320206 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q320206' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL77
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0023' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4725.2100

	(SELECT 'the version of mshtml.dll is less than 5.50.4725.2100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4725 OR Version3 = 4725 AND
		Version4 < 2100))))))

AND NOT EXISTS

	-- the patch q316059 is installed (Installed Components key)

	(SELECT 'the patch q316059 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL78
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0333' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\ism.dll version is less than 5.0.2195.3407

	(SELECT 'File %windir%\system32\inetsrv\ism.dll version is less than 5.0.2195.3407' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\ism.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 3407))))))

AND NOT EXISTS

	-- Patch Q293826 Installed

	(SELECT 'Patch Q293826 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q293826' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Security Roll-up 1 Installed

	(SELECT 'Windows 2000 Security Roll-up 1 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL81
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0148' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL82
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-0509' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- the version of ssmsrp70.dll is less than 2000.80.213.0

	(SELECT 'the version of ssmsrp70.dll is less than 2000.80.213.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssmsrp70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 213 OR Version3 = 213 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of dbmsrpcn.dll is less than 2000.80.213.0

	(SELECT 'the version of dbmsrpcn.dll is less than 2000.80.213.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dbmsrpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 213 OR Version3 = 213 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- File sqlservr.exe version3 greater than or equal to 384

	(SELECT 'File sqlservr.exe version3 greater than or equal to 384' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 >= 2000 AND
	Version2 >= 80 AND
	Version3 >= 384 AND
	Version4 >= 0))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL83
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-0542' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File sqlservr.exe version3 less than 428

	(SELECT 'File sqlservr.exe version3 less than 428' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 428 OR Version3 = 428 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL87
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0013' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of snmp.exe is less than 4.0.1381.7134

	(SELECT 'the version of snmp.exe is less than 4.0.1381.7134' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\snmp.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7134))))))

AND NOT EXISTS

	-- Patch Q314147 Installed

	(SELECT 'Patch Q314147 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q314147' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL89
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0151' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\drivers\mup.sys version is less than 5.0.2195.5080

	(SELECT 'File %windir%\system32\drivers\mup.sys version is less than 5.0.2195.5080' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\drivers\mup.sys' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5080))))))

AND NOT EXISTS

	-- Patch Q311967 Installed

	(SELECT 'Patch Q311967 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q311967' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL90
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0151' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\httpext.dll version is less than 0.9.3940.20

	(SELECT 'File %windir%\system32\inetsrv\httpext.dll version is less than 0.9.3940.20' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\httpext.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 0 OR (Version1 = 0 AND
		(Version2 < 9 OR (Version2 = 9 AND
		(Version3 < 3940 OR Version3 = 3940 AND
		Version4 < 20))))))

AND NOT EXISTS

	-- Patch Q291845 Installed

	(SELECT 'Patch Q291845 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q291845' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q293826 Installed

	(SELECT 'Patch Q293826 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q293826' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 is installed

	(SELECT 'Win2K/XP/2003 service pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- WebDav is disabled(for iis 5.0)

	(SELECT 'WebDav is disabled(for iis 5.0)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W3SVC\Parameters' AND
		EntryName = 'DisableWebDAV' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL92
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0148' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL95
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0149' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL96
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0078' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2715.400

	(SELECT 'the version of mshtml.dll is less than 6.0.2715.400' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2715 OR Version3 = 2715 AND
		Version4 < 400))))))

AND NOT EXISTS

	-- the patch q319282 is installed (Installed Components key)

	(SELECT 'the patch q319282 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- cookies are enabled
	(SELECT 'cookies are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and cookies are enabled
		(SELECT 'current user settings are being used and cookies are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- persistent cookies that are stored on your computer are enabled for the local machine

			(SELECT 'persistent cookies that are stored on your computer are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1A02' AND
				EntryValue != '3')

		AND EXISTS
			-- persistent cookies that are stored on your computer are enabled for the current user

			(SELECT 'persistent cookies that are stored on your computer are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1A02' AND
				EntryValue != '3'))

	AND EXISTS
		-- local machine settings are being used and cookies are enabled
		(SELECT 'local machine settings are being used and cookies are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- per-session cookies (not stored) are enabled for the local machine

			(SELECT 'per-session cookies (not stored) are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1A03' AND
				EntryValue != '3')

		AND EXISTS
			-- per-session cookies (not stored) are enabled for the current user

			(SELECT 'per-session cookies (not stored) are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1A03' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL98
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0371' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- File %windir%\system32\mshtml.dll version is less than 6.0.2719.2200

	(SELECT 'File %windir%\system32\mshtml.dll version is less than 6.0.2719.2200' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2719 OR Version3 = 2719 AND
		Version4 < 2200))))))

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Gopher Enabled

	(SELECT 'Gopher Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\URL\Prefixes' AND
		EntryName = 'gopher' AND
		EntryValue = 'gopher://')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL99
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0193' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2716.2200

	(SELECT 'the version of mshtml.dll is less than 6.0.2716.2200' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2716 OR Version3 = 2716 AND
		Version4 < 2200))))))

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- SP4 or later Installed

		(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue >= 'Service Pack 4'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL103
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0003' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of locator.exe is less than 4.0.1381.7202

	(SELECT 'the version of locator.exe is less than 4.0.1381.7202' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Locator.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7202))))))

AND NOT EXISTS

	-- Patch Q810833 Installed

	(SELECT 'Patch Q810833 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q810833' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Locator Enabled

	(SELECT 'Locator Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RPCLocator' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL109
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0109' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of ntdll.dll is less than 5.0.2195.6685

	(SELECT 'the version of ntdll.dll is less than 5.0.2195.6685' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\ntdll.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6685))))))

AND NOT EXISTS

	-- the patch q815021 is installed

	(SELECT 'the patch q815021 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q815021' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL117
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0526' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- ISA Server 2000 is installed

	(SELECT 'ISA Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
		EntryName = 'VersionMajor' AND
		EntryValue = '3')

AND NOT EXISTS

	-- ISA2000-KB816456-x86.exe

	(SELECT 'ISA2000-KB816456-x86.exe' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\277' AND
		EntryName = 'Kbs' AND
		EntryValue = '816456')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL118
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0345' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- File %windir%\system32\Drivers\SRV.SYS is less than 5.0.2195.6699

	(SELECT 'File %windir%\system32\Drivers\SRV.SYS is less than 5.0.2195.6699' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Drivers\SRV.SYS' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6699))))))

AND NOT EXISTS

	-- Patch Windows2000-KB817606-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB817606-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB817606' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL121
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0154' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.608.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.608.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 608 OR Version3 = 608 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.606.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpqueue.dll is less than 2000.80.606.0

	(SELECT 'the version of xpqueue.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpqueue.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xprepl.dll is less than 2000.80.606.0

	(SELECT 'the version of xprepl.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xprepl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xplog70.dll is less than 2000.80.606.0

	(SELECT 'the version of xplog70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xplog70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.606.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpstar.dll is less than 2000.80.628.0

	(SELECT 'the version of xpstar.dll is less than 2000.80.628.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpstar.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 628 OR Version3 = 628 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL123
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0809' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 or IE 6.0 SP1 is installed
	(SELECT 'Internet Explorer 6.0 or IE 6.0 SP1 is installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 6 is installed

		(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2600.0000')

	OR EXISTS
		-- Internet Explorer 6 Service Pack 1 is installed

		(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2800.1106'))

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1264

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1264' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1264))))))

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls are enabled
	(SELECT 'ActiveX controls are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls are enabled
		(SELECT 'current user settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls are enabled
		(SELECT 'local machine settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')))

AND EXISTS

	-- .hta applications are enabled

	(SELECT '.hta applications are enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/hta' AND
		EntryName = 'Extension' AND
		EntryValue = '.hta')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL126
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-1326' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2723.2500

	(SELECT 'the version of mshtml.dll is less than 6.0.2723.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2723 OR Version3 = 2723 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL127
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0528' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of rpcrt4.dll is less than 5.0.2195.6802

	(SELECT 'the version of rpcrt4.dll is less than 5.0.2195.6802' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6802))))))

AND NOT EXISTS

	-- the patch kb824146 is installed (Hotfix key)

	(SELECT 'the patch kb824146 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824146' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- DCOM is enabled on systems with SP3 or later
	(SELECT 'DCOM is enabled on systems with SP3 or later' FROM Placeholder WHERE

	EXISTS
		-- Win2K/XP/2003 service pack 3 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

	AND EXISTS
		-- DCOM is enabled

		(SELECT 'DCOM is enabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
			EntryName = 'EnableDCOM' AND
			EntryValue = 'Y'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL130
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0071' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ism.dll mapping exists

	(SELECT 'ism.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ism.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL132
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0149' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL136
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0111' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of msjava.dll is less than 5.0.3810.0

	(SELECT 'the version of msjava.dll is less than 5.0.3810.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msjava.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3810 OR Version3 = 3810 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL137
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0150' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of w3svc.dll is less than 4.2.775.1

	(SELECT 'the version of w3svc.dll is less than 4.2.775.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 775 OR Version3 = 775 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- asp.dll mapping exists

	(SELECT 'asp.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%asp.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL139
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-0046' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- For Windows NT 4.0 Workstation, Server and Enterprise Edition
	(SELECT 'For Windows NT 4.0 Workstation, Server and Enterprise Edition' FROM Placeholder WHERE

	EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7064))))))

	AND NOT EXISTS
		-- Windows NT 4.0 Security Roll-up Package

		(SELECT 'Windows NT 4.0 Security Roll-up Package' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q299444' AND
			EntryName = 'Installed' AND
			EntryValue = '1'))

AND EXISTS

	-- For Terminal Server
	(SELECT 'For Terminal Server' FROM Placeholder WHERE

	EXISTS
		-- this is an NT Terminal Server

		(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductSuite' AND
			EntryValue = 'Terminal Server')

	AND EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7097)))))))

AND NOT EXISTS

	-- Patch Q265714 Installed

	(SELECT 'Patch Q265714 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q265714' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL140
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-0047' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- For Windows NT 4.0 Workstation, Server and Enterprise Edition
	(SELECT 'For Windows NT 4.0 Workstation, Server and Enterprise Edition' FROM Placeholder WHERE

	EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7064))))))

	AND NOT EXISTS
		-- Windows NT 4.0 Security Roll-up Package

		(SELECT 'Windows NT 4.0 Security Roll-up Package' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q299444' AND
			EntryName = 'Installed' AND
			EntryValue = '1'))

AND EXISTS

	-- For Terminal Server
	(SELECT 'For Terminal Server' FROM Placeholder WHERE

	EXISTS
		-- this is an NT Terminal Server

		(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductSuite' AND
			EntryValue = 'Terminal Server')

	AND EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7097)))))))

AND NOT EXISTS

	-- Patch Q265714 Installed

	(SELECT 'Patch Q265714 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q265714' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- MTS Enabled

	(SELECT 'MTS Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Transaction Server\Packages' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL141
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0154' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Installed
	(SELECT 'Internet Explorer 5.01 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.3800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.6307')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2920.0000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3103.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3105.0106'))

AND EXISTS

	-- File %windir%\system32\shdocvw.dll version is less than 5.0.3214.2000

	(SELECT 'File %windir%\system32\shdocvw.dll version is less than 5.0.3214.2000' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shdocvw.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3214 OR Version3 = 3214 AND
		Version4 < 2000))))))

AND NOT EXISTS

	-- the patch q290108 is installed

	(SELECT 'the patch q290108 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{90A2A715-D986-4EAB-8C73-4D06114EF760}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q295106 is installed

	(SELECT 'the patch q295106 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{754D29C1-0C97-405F-98D0-21B212CA7FF1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 is installed

	(SELECT 'Win2K/XP/2003 service pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- file downloads are enabled
	(SELECT 'file downloads are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and file downloads are enabled
		(SELECT 'current user settings are being used and file downloads are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- file downloads are enabled for the local machine

			(SELECT 'file downloads are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1803' AND
				EntryValue != '3'))

	AND EXISTS
		-- local machine settings are being used and file downloads are enabled
		(SELECT 'local machine settings are being used and file downloads are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- file downloads are enabled for the current user

			(SELECT 'file downloads are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1803' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL143
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1186' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2722.900

	(SELECT 'the version of mshtml.dll is less than 6.0.2722.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2722 OR Version3 = 2722 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL144
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0012' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of snmp.exe is less than 5.0.2195.4919

	(SELECT 'the version of snmp.exe is less than 5.0.2195.4919' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\snmp.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4919))))))

AND NOT EXISTS

	-- Patch Q314147 Installed

	(SELECT 'Patch Q314147 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q314147' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL145
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0151' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of mup.sys is less than 4.0.1381.7125

	(SELECT 'the version of mup.sys is less than 4.0.1381.7125' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\drivers\mup.sys' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7125))))))

AND NOT EXISTS

	-- Patch Q312895 Installed

	(SELECT 'Patch Q312895 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q312895' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL147
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0070' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of shell32.dll is less than 5.00.3502.4718

	(SELECT 'the version of shell32.dll is less than 5.00.3502.4718' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3502 OR Version3 = 3502 AND
		Version4 < 4718))))))

AND NOT EXISTS

	-- Patch Q313829 Installed

	(SELECT 'Patch Q313829 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q313829' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL158
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0367' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of smss.exe is less than 4.0.1381.7152

	(SELECT 'the version of smss.exe is less than 4.0.1381.7152' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\smss.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7152))))))

AND NOT EXISTS

	-- Patch Q320206 Installed

	(SELECT 'Patch Q320206 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q320206' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL159
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0018' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of netlogon.dll is less than 4.0.1381.7092

	(SELECT 'the version of netlogon.dll is less than 4.0.1381.7092' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netlogon.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7092))))))

AND NOT EXISTS

	-- Windows NT 4.0 Security Roll-up Package

	(SELECT 'Windows NT 4.0 Security Roll-up Package' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q299444' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL161
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0012' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of snmp.exe is less than 4.0.1381.7134

	(SELECT 'the version of snmp.exe is less than 4.0.1381.7134' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\snmp.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7134))))))

AND NOT EXISTS

	-- Patch Q314147 Installed

	(SELECT 'Patch Q314147 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q314147' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL178
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-1326' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4923.2500

	(SELECT 'the version of mshtml.dll is less than 5.50.4923.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4923 OR Version3 = 4923 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL182
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0364' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\ism.dll version is less than 4.2.776.1

	(SELECT 'File %windir%\system32\inetsrv\ism.dll version is less than 4.2.776.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\ism.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 776 OR Version3 = 776 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q321599 Installed

	(SELECT 'Patch Q321599 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q321599' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ism.dll mapping exists

	(SELECT 'ism.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ism.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL185
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0660' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of cryptui.dll exists
	(SELECT 'a vulnerable version of cryptui.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and cryptui.dll is less than 5.131.2600.117
		(SELECT 'no service pack is installed and cryptui.dll is less than 5.131.2600.117' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of cryptui.dll is less than 5.131.2600.117

			(SELECT 'the version of cryptui.dll is less than 5.131.2600.117' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\cryptui.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 131 OR (Version2 = 131 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 117)))))))

	OR EXISTS
		-- service pack 1 is installed and cryptui.dll is less than 5.131.2600.1243
		(SELECT 'service pack 1 is installed and cryptui.dll is less than 5.131.2600.1243' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of cryptui.dll is less than 5.131.2600.1243

			(SELECT 'the version of cryptui.dll is less than 5.131.2600.1243' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\cryptui.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 131 OR (Version2 = 131 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1243))))))))

AND NOT EXISTS

	-- Patch WindowsXP-KB823182-x86-ENU Installed

	(SELECT 'Patch WindowsXP-KB823182-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823182' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- downloading of signed ActiveX controls is enabled
	(SELECT 'downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'current user settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the local machine

			(SELECT 'downloading of signed ActiveX controls is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3'))

	AND EXISTS
		-- local machine settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'local machine settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the current user

			(SELECT 'downloading of signed ActiveX controls is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL188
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0664' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Word 2000 is installed

	(SELECT 'Word 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\9.0\Word\InstallRoot')

AND EXISTS

	-- the version of winword.exe is less than 9.0.0.7924

	(SELECT 'the version of winword.exe is less than 9.0.0.7924' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\winword.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe' AND
			EntryName = 'Path') AND
		(Version1 < 9 OR (Version1 = 9 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 7924))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL189
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0724' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of xactsrv.dll is less than 5.0.2195.5971

	(SELECT 'the version of xactsrv.dll is less than 5.0.2195.5971' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\xactsrv.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5971))))))

AND NOT EXISTS

	-- Patch Q326830 Installed

	(SELECT 'Patch Q326830 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q326830' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Lanman enabled

	(SELECT 'Lanman enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\lanmanserver' AND
		EntryName = 'Start' AND
		EntryValue != '2')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL190
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0699' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of xenroll.dll is less than 5.131.3659.0

	(SELECT 'the version of xenroll.dll is less than 5.131.3659.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\xenroll.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 131 OR (Version2 = 131 AND
		(Version3 < 3659 OR Version3 = 3659 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- Patch Q323172 Installed

	(SELECT 'Patch Q323172 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q323172' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX Enabled
	(SELECT 'ActiveX Enabled' FROM Placeholder WHERE

	EXISTS
		-- use machine settings rather than individual user settings

		(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
			EntryName = 'Security_HKLM_only' AND
			EntryValue = '1')

	AND EXISTS
		-- ActiveX Enabled In At Least One Zone

		(SELECT 'ActiveX Enabled In At Least One Zone' FROM Windows_RegistryKeys WHERE
			RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
			EntryName = '1200' AND
			EntryValue = '0'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL191
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2000-0886' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\w3svc.dll version is less than 5.0.2195.2784

	(SELECT 'File %windir%\system32\inetsrv\w3svc.dll version is less than 5.0.2195.2784' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 2784))))))

AND NOT EXISTS

	-- Patch Q277873 Installed

	(SELECT 'Patch Q277873 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q277873' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q293826 Installed

	(SELECT 'Patch Q293826 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q293826' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 is installed

	(SELECT 'Win2K/XP/2003 service pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL197
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0500' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\idq.dll version is less than 5.0.2195.3645

	(SELECT 'File %windir%\system32\idq.dll version is less than 5.0.2195.3645' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\idq.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 3645))))))

AND NOT EXISTS

	-- Patch Q300972 Installed

	(SELECT 'Patch Q300972 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q300972' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Security Roll-up 1 Installed

	(SELECT 'Windows 2000 Security Roll-up 1 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- idq.dll mapping exists

	(SELECT 'idq.dll mapping exists' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%idq.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL198
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0660' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\cryptui.dll version is less than 5.131.2195.6758

	(SELECT 'File %windir%\system32\cryptui.dll version is less than 5.131.2195.6758' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\cryptui.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 131 OR (Version2 = 131 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6758))))))

AND NOT EXISTS

	-- Patch WindowsXP-KB823182-x86-ENU Installed

	(SELECT 'Patch WindowsXP-KB823182-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823182' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- downloading of signed ActiveX controls is enabled
	(SELECT 'downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'current user settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the local machine

			(SELECT 'downloading of signed ActiveX controls is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3'))

	AND EXISTS
		-- local machine settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'local machine settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the current user

			(SELECT 'downloading of signed ActiveX controls is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL199
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0863' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Terminal Server Version

	(SELECT 'Terminal Server Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Terminal Server' AND
		EntryName = 'ProductVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\drivers\rdpwd.sys version is less than 5.0.2195.5880

	(SELECT 'File %windir%\system32\drivers\rdpwd.sys version is less than 5.0.2195.5880' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\drivers\rdpwd.sys' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5880))))))

AND NOT EXISTS

	-- Patch Q324380 installed

	(SELECT 'Patch Q324380 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q324380' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- RDP Enabled

	(SELECT 'RDP Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RDPWD' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL200
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0010' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of jscript.dll is less than 5.6.0.8513

	(SELECT 'the version of jscript.dll is less than 5.6.0.8513' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\jscript.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 6 OR (Version2 = 6 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 8513))))))

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND NOT EXISTS

	-- the patch js56nen.exe (5.6.0.8513 version) is installed

	(SELECT 'the patch js56nen.exe (5.6.0.8513 version) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{4f645220-306d-11d2-995d-00c04f98bbc9}' AND
		EntryName = 'Version' AND
		EntryValue = '5,6,0,8513')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- active scripting is enabled
	(SELECT 'active scripting is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and active scripting is enabled
		(SELECT 'current user settings are being used and active scripting is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and active scripting is enabled
		(SELECT 'local machine settings are being used and active scripting is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL201
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0659' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of user32.dll exists
	(SELECT 'a vulnerable version of user32.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and user32.dll is less than 5.1.2600.118
		(SELECT 'no service pack is installed and user32.dll is less than 5.1.2600.118' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of user32.dll is less than 5.1.2600.118

			(SELECT 'the version of user32.dll is less than 5.1.2600.118' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\user32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 118)))))))

	OR EXISTS
		-- service pack 1 is installed and user32.dll is less than 5.1.2600.1255
		(SELECT 'service pack 1 is installed and user32.dll is less than 5.1.2600.1255' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of user32.dll is less than 5.1.2600.1255

			(SELECT 'the version of user32.dll is less than 5.1.2600.1255' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\user32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1255))))))))

AND NOT EXISTS

	-- the patch kb824141 is installed (Hotfix key)

	(SELECT 'the patch kb824141 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824141' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the utility manager Service is enabled

	(SELECT 'the utility manager Service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\UtilMan' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL202
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1143' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- Word 2000 is installed

	(SELECT 'Word 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\9.0\Word\InstallRoot')

AND EXISTS

	-- the version of winword.exe is less than 9.0.0.6926

	(SELECT 'the version of winword.exe is less than 9.0.0.6926' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\winword.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe' AND
			EntryName = 'Path') AND
		(Version1 < 9 OR (Version1 = 9 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 6926))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL203
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1187' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2722.900

	(SELECT 'the version of mshtml.dll is less than 6.0.2722.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2722 OR Version3 = 2722 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL204
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0838' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 or IE 6.0 SP1 is installed
	(SELECT 'Internet Explorer 6.0 or IE 6.0 SP1 is installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 6 is installed

		(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2600.0000')

	OR EXISTS
		-- Internet Explorer 6 Service Pack 1 is installed

		(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2800.1106'))

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1264

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1264' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1264))))))

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls are enabled
	(SELECT 'ActiveX controls are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls are enabled
		(SELECT 'current user settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls are enabled
		(SELECT 'local machine settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')))

AND EXISTS

	-- .hta applications are enabled

	(SELECT '.hta applications are enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/hta' AND
		EntryName = 'Extension' AND
		EntryValue = '.hta')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL205
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1056' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Word 2000 is installed

	(SELECT 'Word 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\9.0\Word\InstallRoot')

AND EXISTS

	-- the version of winword.exe is less than 9.0.0.6328

	(SELECT 'the version of winword.exe is less than 9.0.0.6328' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\winword.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe' AND
			EntryName = 'Path') AND
		(Version1 < 9 OR (Version1 = 9 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 6328))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL206
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1048' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3532.300

	(SELECT 'the version of mshtml.dll is less than 5.0.3532.300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3532 OR Version3 = 3532 AND
		Version4 < 300))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL207
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0549' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.3790.191

	(SELECT 'the version of mshtml.dll is less than 6.00.3790.191' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 191))))))

AND NOT EXISTS

	-- the patch kb867801 is installed (Hotfix key)

	(SELECT 'the patch kb867801 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB867801' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL209
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0053' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of snmp.exe is less than 5.0.2195.4919

	(SELECT 'the version of snmp.exe is less than 5.0.2195.4919' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\snmp.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4919))))))

AND NOT EXISTS

	-- Patch Q314147 Installed

	(SELECT 'Patch Q314147 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q314147' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL210
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0075' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- the version of w3svc.dll is less than 5.0.2195.5269

	(SELECT 'the version of w3svc.dll is less than 5.0.2195.5269' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 5269))))))

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL212
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1048' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3532.300

	(SELECT 'the version of mshtml.dll is less than 5.0.3532.300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3532 OR Version3 = 3532 AND
		Version4 < 300))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL213
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0717' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of msgsvc.dll is less than 5.0.2195.6861

	(SELECT 'the version of msgsvc.dll is less than 5.0.2195.6861' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msgsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6861))))))

AND EXISTS

	-- the version of wkssvc.dll is less than 5.0.2195.6861

	(SELECT 'the version of wkssvc.dll is less than 5.0.2195.6861' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wkssvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6861))))))

AND NOT EXISTS

	-- the patch q828035 is installed (Hotfix key)

	(SELECT 'the patch q828035 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828035' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the messenger service is enabled

	(SELECT 'the messenger service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Messenger' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL216
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0566' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3819.300

	(SELECT 'the version of mshtml.dll is less than 5.00.3819.300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3819 OR Version3 = 3819 AND
		Version4 < 300))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL217
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0711' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of itircl.dll is less than 5.2.3790.80

	(SELECT 'the version of itircl.dll is less than 5.2.3790.80' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itircl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 80))))))

AND NOT EXISTS

	-- Patch KB825119 Installed

	(SELECT 'Patch KB825119 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB825119' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- HCP Protocol

	(SELECT 'HCP Protocol' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_CLASSES_ROOT\HCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL225
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1187' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4922.900

	(SELECT 'the version of mshtml.dll is less than 5.50.4922.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4922 OR Version3 = 4922 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL231
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2000-1081' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File odsole70.dll Version3 is less than 223

	(SELECT 'File odsole70.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND EXISTS

	-- File xpqueue.dll Version3 is less than 223

	(SELECT 'File xpqueue.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpqueue.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND EXISTS

	-- File xprepl.dll Version3 is less than 223

	(SELECT 'File xprepl.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xprepl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND EXISTS

	-- File xpstar.dll Version3 is less than 223

	(SELECT 'File xpstar.dll Version3 is less than 223' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpstar.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 223 OR Version3 = 223 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- File sqlservr.exe version3 greater than or equal to 384

	(SELECT 'File sqlservr.exe version3 greater than or equal to 384' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 >= 2000 AND
	Version2 >= 80 AND
	Version3 >= 384 AND
	Version4 >= 0))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL235
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0230' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File console.exe version3 is less than 818

	(SELECT 'File console.exe version3 is less than 818' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'console.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- File dbmslpcn.dll version3 is less than 818

	(SELECT 'File dbmslpcn.dll version3 is less than 818' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dbmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WindowsNT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlmap70.dll version3 is less than 811

	(SELECT 'File sqlmap70.dll version3 is less than 811' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlmap70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 811 OR Version3 = 811 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlrepss.dll version3 is less than 765

	(SELECT 'File sqlrepss.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlrepss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.818.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssmslpcn.dll is less than 2000.80.818.0

	(SELECT 'the version of ssmslpcn.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnetlib.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnetlib.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnetlib.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnmpn70.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnmpn70.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnmpn70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ums.dll is less than 2000.80.816.0

	(SELECT 'the version of ums.dll is less than 2000.80.816.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ums.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 816 OR Version3 = 816 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.800.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.800.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 800 OR Version3 = 800 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.778.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.778.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 778 OR Version3 = 778 AND
		Version4 < 0))))))

AND EXISTS

	-- File msgprox.dll version3 is less than 765

	(SELECT 'File msgprox.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'msgprox.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of replprov.dll is less than 2000.80.798.0

	(SELECT 'the version of replprov.dll is less than 2000.80.798.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replprov.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 798 OR Version3 = 798 AND
		Version4 < 0))))))

AND EXISTS

	-- File replrec.dll version3 is less than 765

	(SELECT 'File replrec.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replrec.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlvdi.dll version3 is less than 765

	(SELECT 'File sqlvdi.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlvdi.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL236
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1048' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2800.1458

	(SELECT 'the version of mshtml.dll is less than 6.00.2800.1458' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1458))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL237
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0662' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of tshoot.ocx is less than 1.0.1.2125

	(SELECT 'the version of tshoot.ocx is less than 1.0.1.2125' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\tshoot.ocx' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 1 OR (Version1 = 1 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1 OR Version3 = 1 AND
		Version4 < 2125))))))

AND NOT EXISTS

	-- the patch kb826232 is installed

	(SELECT 'the patch kb826232 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB826232' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls are enabled
	(SELECT 'ActiveX controls are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls are enabled
		(SELECT 'current user settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls are enabled
		(SELECT 'local machine settings are being used and ActiveX controls are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL241
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0549' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4943.400

	(SELECT 'the version of mshtml.dll is less than 5.50.4943.400' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4943 OR Version3 = 4943 AND
		Version4 < 400))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL253
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0879' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- Patch Q305601 Installed

	(SELECT 'Patch Q305601 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\Q305601' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL264
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0715' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of rpcrt4.dll is less than 5.0.2195.6802

	(SELECT 'the version of rpcrt4.dll is less than 5.0.2195.6802' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6802))))))

AND NOT EXISTS

	-- the patch kb824146 is installed (Hotfix key)

	(SELECT 'the patch kb824146 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824146' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- DCOM is enabled on systems with SP3 or later
	(SELECT 'DCOM is enabled on systems with SP3 or later' FROM Placeholder WHERE

	EXISTS
		-- Win2K/XP/2003 service pack 3 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

	AND EXISTS
		-- DCOM is enabled

		(SELECT 'DCOM is enabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
			EntryName = 'EnableDCOM' AND
			EntryValue = 'Y'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL268
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0717' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of wkssvc.dll exists
	(SELECT 'a vulnerable version of wkssvc.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and wkssvc.dll is less than 5.1.2600.120
		(SELECT 'no service pack is installed and wkssvc.dll is less than 5.1.2600.120' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of wkssvc.dll is less than 5.1.2600.120

			(SELECT 'the version of wkssvc.dll is less than 5.1.2600.120' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\wkssvc.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 120)))))))

	OR EXISTS
		-- service pack 1 is installed and wkssvc.dll is less than 5.1.2600.1301
		(SELECT 'service pack 1 is installed and wkssvc.dll is less than 5.1.2600.1301' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of wkssvc.dll is less than 5.1.2600.1301

			(SELECT 'the version of wkssvc.dll is less than 5.1.2600.1301' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\wkssvc.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1301))))))))

AND EXISTS

	-- a vulnerable version of msgsvc.dll exists
	(SELECT 'a vulnerable version of msgsvc.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and msgsvc.dll is less than 5.1.2600.120
		(SELECT 'no service pack is installed and msgsvc.dll is less than 5.1.2600.120' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of msgsvc.dll is less than 5.1.2600.120

			(SELECT 'the version of msgsvc.dll is less than 5.1.2600.120' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msgsvc.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 120)))))))

	OR EXISTS
		-- service pack 1 is installed and msgsvc.dll is less than 5.1.2600.1301
		(SELECT 'service pack 1 is installed and msgsvc.dll is less than 5.1.2600.1301' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of msgsvc.dll is less than 5.1.2600.1301

			(SELECT 'the version of msgsvc.dll is less than 5.1.2600.1301' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msgsvc.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1301))))))))

AND NOT EXISTS

	-- the patch q828035 is installed (Hotfix key)

	(SELECT 'the patch q828035 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828035' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the messenger service is enabled

	(SELECT 'the messenger service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Messenger' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL271
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0056' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File sqlservr.exe version3 is less than 578

	(SELECT 'File sqlservr.exe version3 is less than 578' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 578 OR Version3 = 578 AND
		Version4 < 0))))))

AND EXISTS

	-- File xpstar.dll version3 is less than 561

	(SELECT 'File xpstar.dll version3 is less than 561' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpstar.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 561 OR Version3 = 561 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL272
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1217' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2722.900

	(SELECT 'the version of mshtml.dll is less than 6.0.2722.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2722 OR Version3 = 2722 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL277
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1256' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of srvsvc.dll is less than 5.0.2195.6110

	(SELECT 'the version of srvsvc.dll is less than 5.0.2195.6110' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\srvsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- Patch Q329170 Installed

	(SELECT 'Patch Q329170 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329170' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SMB Signing enabled

	(SELECT 'SMB Signing enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\lanmanserver\parameters' AND
		EntryName = 'enablesecuritysignature' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL281
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0372' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Media Player for Windows XP is installed

	(SELECT 'Windows Media Player for Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MediaPlayer\8.0\Registration' AND
		EntryName = 'UDBVersion' AND
		EntryValue = '8.0.0.4477')

AND EXISTS

	-- the version of dxmasf.dll is less than 6.4.9.1121

	(SELECT 'the version of dxmasf.dll is less than 6.4.9.1121' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dxmasf.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 4 OR (Version2 = 4 AND
		(Version3 < 9 OR Version3 = 9 AND
		Version4 < 1121))))))

AND EXISTS

	-- the version of msdxm.ocx is less than 6.4.9.1124

	(SELECT 'the version of msdxm.ocx is less than 6.4.9.1124' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msdxm.ocx' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 4 OR (Version2 = 4 AND
		(Version3 < 9 OR Version3 = 9 AND
		Version4 < 1124))))))

AND EXISTS

	-- the version of wmpcore.dll is less than 8.0.0.4482

	(SELECT 'the version of wmpcore.dll is less than 8.0.0.4482' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wmpcore.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 8 OR (Version1 = 8 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 4482))))))

AND EXISTS

	-- the version of wmplayer.exe is less than 8.0.0.4482

	(SELECT 'the version of wmplayer.exe is less than 8.0.0.4482' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Windows Media Player\wmplayer.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'ProgramFilesDir') AND
		(Version1 < 8 OR (Version1 = 8 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 4482))))))

AND NOT EXISTS

	-- Patch wm320920_8.exe Installed

	(SELECT 'Patch wm320920_8.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Player\wm320920' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL287
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0719' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Media Player for Windows XP is installed

	(SELECT 'Windows Media Player for Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MediaPlayer\8.0\Registration' AND
		EntryName = 'UDBVersion' AND
		EntryValue = '8.0.0.4477')

AND EXISTS

	-- the version of msdxm.ocx is less than 6.4.9.1121

	(SELECT 'the version of msdxm.ocx is less than 6.4.9.1121' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msdxm.ocx' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 4 OR (Version2 = 4 AND
		(Version3 < 9 OR Version3 = 9 AND
		Version4 < 1121))))))

AND EXISTS

	-- the version of dxmasf.dll is less than 6.4.9.1121

	(SELECT 'the version of dxmasf.dll is less than 6.4.9.1121' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dxmasf.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 4 OR (Version2 = 4 AND
		(Version3 < 9 OR Version3 = 9 AND
		Version4 < 1121))))))

AND NOT EXISTS

	-- Patch wm308567 Installed

	(SELECT 'Patch wm308567 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Player\wm308567' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL291
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0624' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.650.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.650.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 650 OR Version3 = 650 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.606.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpqueue.dll is less than 2000.80.606.0

	(SELECT 'the version of xpqueue.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpqueue.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xprepl.dll is less than 2000.80.606.0

	(SELECT 'the version of xprepl.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xprepl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xplog70.dll is less than 2000.80.606.0

	(SELECT 'the version of xplog70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xplog70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.606.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpstar.dll is less than 2000.80.628.0

	(SELECT 'the version of xpstar.dll is less than 2000.80.628.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpstar.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 628 OR Version3 = 628 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Mixed Mode Enabled

	(SELECT 'Mixed Mode Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer' AND
		EntryName = 'LoginMode' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL294
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1142' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of msadco.dll is less than 2.62.9119.1

	(SELECT 'the version of msadco.dll is less than 2.62.9119.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Common Files\System\msadc\msadco.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'ProgramFilesDir') AND
		(Version1 < 2 OR (Version1 = 2 AND
		(Version2 < 62 OR (Version2 = 62 AND
		(Version3 < 9119 OR Version3 = 9119 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q329414 Installed

	(SELECT 'Patch Q329414 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329414' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL296
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0352' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6753

	(SELECT 'File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6753' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6753))))))

AND NOT EXISTS

	-- Patch Windows2000-KB823980-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB823980-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823980' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- DCOM is enabled on systems with SP3 or later
	(SELECT 'DCOM is enabled on systems with SP3 or later' FROM Placeholder WHERE

	EXISTS
		-- Win2K/XP/2003 service pack 3 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

	AND EXISTS
		-- DCOM is enabled

		(SELECT 'DCOM is enabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
			EntryName = 'EnableDCOM' AND
			EntryValue = 'Y'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL298
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0013' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

AND EXISTS

	-- the version of snmp.exe is less than 5.0.2195.4919

	(SELECT 'the version of snmp.exe is less than 5.0.2195.4919' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\snmp.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4919))))))

AND NOT EXISTS

	-- Patch Q314147 Installed

	(SELECT 'Patch Q314147 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q314147' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL299
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0231' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File console.exe version3 is less than 818

	(SELECT 'File console.exe version3 is less than 818' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'console.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of dbmslpcn.dll is less than 2000.80.818.0

	(SELECT 'the version of dbmslpcn.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dbmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlmap70.dll version3 is less than 811

	(SELECT 'File sqlmap70.dll version3 is less than 811' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlmap70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 811 OR Version3 = 811 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlrepss.dll version3 is less than 765

	(SELECT 'File sqlrepss.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlrepss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.818.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssmslpcn.dll is less than 2000.80.818.0

	(SELECT 'the version of ssmslpcn.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnetlib.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnetlib.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnetlib.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnmpn70.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnmpn70.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnmpn70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ums.dll is less than 2000.80.816.0

	(SELECT 'the version of ums.dll is less than 2000.80.816.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ums.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 816 OR Version3 = 816 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.800.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.800.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 800 OR Version3 = 800 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.778.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.778.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 778 OR Version3 = 778 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of msgprox.dll is less than 2000.80.765.0

	(SELECT 'the version of msgprox.dll is less than 2000.80.765.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'msgprox.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of replprov.dll is less than 2000.80.798.0

	(SELECT 'the version of replprov.dll is less than 2000.80.798.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replprov.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 798 OR Version3 = 798 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of replrec.dll is less than 2000.80.765.0

	(SELECT 'the version of replrec.dll is less than 2000.80.765.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replrec.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlvdi.dll is less than 2000.80.765.0

	(SELECT 'the version of sqlvdi.dll is less than 2000.80.765.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlvdi.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL303
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0232' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File console.exe version3 is less than 818

	(SELECT 'File console.exe version3 is less than 818' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'console.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of dbmslpcn.dll is less than 2000.80.818.0

	(SELECT 'the version of dbmslpcn.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dbmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlmap70.dll version3 is less than 811

	(SELECT 'File sqlmap70.dll version3 is less than 811' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlmap70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 811 OR Version3 = 811 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlrepss.dll version3 is less than 765

	(SELECT 'File sqlrepss.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlrepss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.818.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssmslpcn.dll is less than 2000.80.818.0

	(SELECT 'the version of ssmslpcn.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnetlib.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnetlib.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnetlib.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnmpn70.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnmpn70.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnmpn70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ums.dll is less than 2000.80.816.0

	(SELECT 'the version of ums.dll is less than 2000.80.816.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ums.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 816 OR Version3 = 816 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.800.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.800.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 800 OR Version3 = 800 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.778.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.778.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 778 OR Version3 = 778 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of msgprox.dll is less than 2000.80.765.0

	(SELECT 'the version of msgprox.dll is less than 2000.80.765.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'msgprox.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of replprov.dll is less than 2000.80.798.0

	(SELECT 'the version of replprov.dll is less than 2000.80.798.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replprov.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 798 OR Version3 = 798 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of replrec.dll is less than 2000.80.765.0

	(SELECT 'the version of replrec.dll is less than 2000.80.765.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replrec.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlvdi.dll is less than 2000.80.765.0

	(SELECT 'the version of sqlvdi.dll is less than 2000.80.765.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlvdi.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL306
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0566' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3532.300

	(SELECT 'the version of mshtml.dll is less than 5.0.3532.300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3532 OR Version3 = 3532 AND
		Version4 < 300))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL308
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0824' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of shtml.dll is less than 4.0.2.7523

	(SELECT 'the version of shtml.dll is less than 4.0.2.7523' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\isapi\shtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'CommonFilesDir') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 02 OR Version3 = 02 AND
		Version4 < 7523))))))

AND NOT EXISTS

	-- the patch q810217 is installed (Hotfix key)

	(SELECT 'the patch q810217 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB810217' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (2K, XP)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Setup\OC Manager\Subcomponents' AND
		EntryName = 'fp_extensions' AND
		EntryValue = '1')

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL316
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0641' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.650.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.650.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 650 OR Version3 = 650 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.606.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpqueue.dll is less than 2000.80.606.0

	(SELECT 'the version of xpqueue.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpqueue.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xprepl.dll is less than 2000.80.606.0

	(SELECT 'the version of xprepl.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xprepl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xplog70.dll is less than 2000.80.606.0

	(SELECT 'the version of xplog70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xplog70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.606.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpstar.dll is less than 2000.80.628.0

	(SELECT 'the version of xpstar.dll is less than 2000.80.628.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpstar.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 628 OR Version3 = 628 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of impprov.dll is less than 2000.80.650.0

	(SELECT 'the version of impprov.dll is less than 2000.80.650.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'impprov.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 650 OR Version3 = 650 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL319
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0525' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Workstation

	(SELECT 'this is an NT Workstation' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductType' AND
		EntryValue = 'WinNT')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of kernel32.dll is less than 4.0.1381.7224

	(SELECT 'the version of kernel32.dll is less than 4.0.1381.7224' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\kernel32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7224))))))

AND NOT EXISTS

	-- Patch Q823803 Installed

	(SELECT 'Patch Q823803 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q823803' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL321
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0228' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Media Player for Windows XP is installed

	(SELECT 'Windows Media Player for Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MediaPlayer\8.0\Registration' AND
		EntryName = 'UDBVersion' AND
		EntryValue = '8.0.0.4477')

AND EXISTS

	-- the version of wmplayer.exe is less than 8.0.0.4490

	(SELECT 'the version of wmplayer.exe is less than 8.0.0.4490' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Windows Media Player\wmplayer.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'ProgramFilesDir') AND
		(Version1 < 8 OR (Version1 = 8 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 4490))))))

AND NOT EXISTS

	-- Patch WindowsMedia8-KB817787-x86-ENU.exe Installed

	(SELECT 'Patch WindowsMedia8-KB817787-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Player\wm817787' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL322
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0566' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4943.400

	(SELECT 'the version of mshtml.dll is less than 5.50.4943.400' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4943 OR Version3 = 4943 AND
		Version4 < 400))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL331
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0812' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of wkssvc.dll exists
	(SELECT 'a vulnerable version of wkssvc.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and wkssvc.dll is less than 5.1.2600.120
		(SELECT 'no service pack is installed and wkssvc.dll is less than 5.1.2600.120' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of wkssvc.dll is less than 5.1.2600.120

			(SELECT 'the version of wkssvc.dll is less than 5.1.2600.120' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\wkssvc.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 120)))))))

	OR EXISTS
		-- service pack 1 is installed and wkssvc.dll is less than 5.1.2600.1301
		(SELECT 'service pack 1 is installed and wkssvc.dll is less than 5.1.2600.1301' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of wkssvc.dll is less than 5.1.2600.1301

			(SELECT 'the version of wkssvc.dll is less than 5.1.2600.1301' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\wkssvc.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1301))))))))

AND NOT EXISTS

	-- the patch q828035 is installed (Hotfix key)

	(SELECT 'the patch q828035 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828035' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the workstation service is enabled

	(SELECT 'the workstation service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\lanmanworkstation' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL333
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1217' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4922.900

	(SELECT 'the version of mshtml.dll is less than 5.50.4922.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4922 OR Version3 = 4922 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL334
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0543' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

AND EXISTS

	-- the version of nntpsvc.dll is less than 5.0.2195.3881

	(SELECT 'the version of nntpsvc.dll is less than 5.0.2195.3881' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\nntpsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 3881))))))

AND NOT EXISTS

	-- Patch Q303984 Installed

	(SELECT 'Patch Q303984 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q303984' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the NNTP service is enabled

	(SELECT 'the NNTP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NntpSvc' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL335
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0814' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL336
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0820' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Word 2000 is installed

	(SELECT 'Word 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\9.0\Word\InstallRoot')

AND EXISTS

	-- the version of winword.exe is less than 9.0.0.8216

	(SELECT 'the version of winword.exe is less than 9.0.0.8216' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\winword.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe' AND
			EntryName = 'Path') AND
		(Version1 < 9 OR (Version1 = 9 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 8216))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL340
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0659' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\user32.dll version is less than 5.00.2195.6799

	(SELECT 'File %windir%\system32\user32.dll version is less than 5.00.2195.6799' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\user32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6799))))))

AND NOT EXISTS

	-- the patch kb824141 is installed (Hotfix key)

	(SELECT 'the patch kb824141 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824141' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the utility manager Service is enabled

	(SELECT 'the utility manager Service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\UtilMan' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL341
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0814' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL342
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0814' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3810.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3810.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3810 OR Version3 = 3810 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL343
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0814' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4934.1600

	(SELECT 'the version of mshtml.dll is less than 5.50.4934.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4934 OR Version3 = 4934 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL344
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0814' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1276

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1276' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1276))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL349
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0814' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.3790.94

	(SELECT 'the version of mshtml.dll is less than 6.0.3790.94' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 94))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Hotfix key)

	(SELECT 'the patch q824145 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824245' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL351
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL352
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL353
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3810.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3810.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3810 OR Version3 = 3810 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL356
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4934.1600

	(SELECT 'the version of mshtml.dll is less than 5.50.4934.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4934 OR Version3 = 4934 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL357
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1276

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1276' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1276))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL359
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.3790.94

	(SELECT 'the version of mshtml.dll is less than 6.0.3790.94' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 94))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Hotfix key)

	(SELECT 'the patch q824145 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824245' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL361
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0816' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL362
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0816' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL363
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0816' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3810.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3810.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3810 OR Version3 = 3810 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL364
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0822' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- a vulnerable version of fp30reg.dll or fp4areg.dll exists
	(SELECT 'a vulnerable version of fp30reg.dll or fp4areg.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of fp4areg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp4areg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp4areg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523))))))

	OR EXISTS
		-- the version of fp30reg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp30reg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp30reg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523)))))))

AND NOT EXISTS

	-- the patch q810217 is installed (Hotfix key)

	(SELECT 'the patch q810217 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB810217' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (2K, XP)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Setup\OC Manager\Subcomponents' AND
		EntryName = 'fp_extensions' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL366
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0822' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT, 2000, or XP is installed
	(SELECT 'Windows NT, 2000, or XP is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	OR EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	OR EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1'))

AND EXISTS

	-- a vulnerable version of fp30reg.dll or fp5areg.dll exists
	(SELECT 'a vulnerable version of fp30reg.dll or fp5areg.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of fp5areg.dll is less than 10.00.4205.0000

		(SELECT 'the version of fp5areg.dll is less than 10.00.4205.0000' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\50\bin\fp5areg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 10 OR (Version1 = 10 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 4205 OR Version3 = 4205 AND
			Version4 < 0000))))))

	OR EXISTS
		-- the version of fp30reg.dll is less than 10.00.4205.0000

		(SELECT 'the version of fp30reg.dll is less than 10.00.4205.0000' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\50\bin\fp30reg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 10 OR (Version1 = 10 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 4205 OR Version3 = 4205 AND
			Version4 < 0000)))))))

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)

	(SELECT 'FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\5.0\Setup Packages' AND
		EntryName = 'Microsoft FrontPage Server Extensions 2002')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL367
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0822' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000, XP, or 2003 is installed
	(SELECT 'Windows 2000, XP, or 2003 is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	OR EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	OR EXISTS
		-- Windows Server 2003 is installed

		(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.2'))

AND EXISTS

	-- a vulnerable version of fp30reg.dll or fp5areg.dll exists
	(SELECT 'a vulnerable version of fp30reg.dll or fp5areg.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of fp5areg.dll is less than 10.00.4205.0000

		(SELECT 'the version of fp5areg.dll is less than 10.00.4205.0000' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\50\bin\fp5areg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 10 OR (Version1 = 10 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 4205 OR Version3 = 4205 AND
			Version4 < 0000))))))

	OR EXISTS
		-- the version of fp30reg.dll is less than 10.00.4205.0000

		(SELECT 'the version of fp30reg.dll is less than 10.00.4205.0000' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\50\bin\fp30reg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 10 OR (Version1 = 10 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 4205 OR Version3 = 4205 AND
			Version4 < 0000)))))))

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)

	(SELECT 'FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\5.0\Setup Packages' AND
		EntryName = 'Microsoft FrontPage Server Extensions 2002')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL368
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0823' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL369
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0823' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL370
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0823' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3810.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3810.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3810 OR Version3 = 3810 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL371
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0823' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4934.1600

	(SELECT 'the version of mshtml.dll is less than 5.50.4934.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4934 OR Version3 = 4934 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL372
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0823' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1276

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1276' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1276))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL373
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0225' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\asp.dll version is less than 5.0.2195.6672

	(SELECT 'File %windir%\system32\inetsrv\asp.dll version is less than 5.0.2195.6672' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\asp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6672))))))

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL374
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0693' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of hhctrl.ocx is less than 5.2.3669.0

	(SELECT 'the version of hhctrl.ocx is less than 5.2.3669.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\hhctrl.ocx' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3669 OR Version3 = 3669 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of hhsetup.dll is less than 5.2.3644.0

	(SELECT 'the version of hhsetup.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\hhsetup.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of itircl.dll is less than 5.2.3644.0

	(SELECT 'the version of itircl.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itircl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of itss.dll is less than 5.2.3644.0

	(SELECT 'the version of itss.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- the patch q323255 is installed (Hotfix key)

	(SELECT 'the patch q323255 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q323255' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- active scripting is enabled
	(SELECT 'active scripting is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and active scripting is enabled
		(SELECT 'current user settings are being used and active scripting is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and active scripting is enabled
		(SELECT 'local machine settings are being used and active scripting is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL388
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1254' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2722.900

	(SELECT 'the version of mshtml.dll is less than 6.0.2722.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2722 OR Version3 = 2722 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL392
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0814' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2734.1600

	(SELECT 'the version of mshtml.dll is less than 6.0.2734.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2734 OR Version3 = 2734 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL393
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1185' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2722.900

	(SELECT 'the version of mshtml.dll is less than 6.0.2722.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2722 OR Version3 = 2722 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL402
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0053' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of snmp.exe is less than 5.0.2195.4919

	(SELECT 'the version of snmp.exe is less than 5.0.2195.4919' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\snmp.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 4919))))))

AND NOT EXISTS

	-- Patch Q314147 Installed

	(SELECT 'Patch Q314147 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q314147' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL403
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0694' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of hhsetup.dll is less than 5.2.3644.0

	(SELECT 'the version of hhsetup.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\hhsetup.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of itircl.dll is less than 5.2.3644.0

	(SELECT 'the version of itircl.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itircl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of itss.dll is less than 5.2.3644.0

	(SELECT 'the version of itss.dll is less than 5.2.3644.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3644 OR Version3 = 3644 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- the patch q323255 is installed (Hotfix key)

	(SELECT 'the patch q323255 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q323255' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL406
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0110' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- ISA Server 2000 is installed

	(SELECT 'ISA Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
		EntryName = 'VersionMajor' AND
		EntryValue = '3')

AND EXISTS

	-- the version of w3proxy.exe is less than 3.0.1200.257

	(SELECT 'the version of w3proxy.exe is less than 3.0.1200.257' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\w3proxy.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
			EntryName = 'InstallationLocation') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1200 OR Version3 = 1200 AND
		Version4 < 257))))))

AND EXISTS

	-- the version of wpsrv.exe is less than 3.0.1200.257

	(SELECT 'the version of wpsrv.exe is less than 3.0.1200.257' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\wspsrv.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
			EntryName = 'InstallationLocation') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1200 OR Version3 = 1200 AND
		Version4 < 257))))))

AND NOT EXISTS

	-- Patch isahf257 installed

	(SELECT 'Patch isahf257 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\257' AND
		EntryName = 'Kbs' AND
		EntryValue = '331066')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Microsoft Firewall Service Enabled

	(SELECT 'Microsoft Firewall Service Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Fwsrv' AND
		EntryName = 'Start' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL408
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1254' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4922.900

	(SELECT 'the version of mshtml.dll is less than 5.50.4922.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4922 OR Version3 = 4922 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL409
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0816' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4934.1600

	(SELECT 'the version of mshtml.dll is less than 5.50.4934.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4934 OR Version3 = 4934 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL416
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0816' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1276

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1276' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1276))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL424
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0020' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of tlntsvr.exe is less than 5.0.33668.1

	(SELECT 'the version of tlntsvr.exe is less than 5.0.33668.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\tlntsvr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 33668 OR Version3 = 33668 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q307298 Installed

	(SELECT 'Patch Q307298 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q307298' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Security Roll-up 1 Installed

	(SELECT 'Windows 2000 Security Roll-up 1 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the telnet service is enabled

	(SELECT 'the telnet service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tlntsvr' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL429
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1056' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- Word 2002 is installed

	(SELECT 'Word 2002 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\10.0\Word\InstallRoot')

AND EXISTS

	-- the version of msohev.dll less than 10.0.2609.0

	(SELECT 'the version of msohev.dll less than 10.0.2609.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\10.0\Common\InstallRoot\msohev.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft' AND
			EntryName = 'Office') AND
		(Version1 < 10 OR (Version1 = 10 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2609 OR Version3 = 2609 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL444
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1188' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2722.900

	(SELECT 'the version of mshtml.dll is less than 6.0.2722.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2722 OR Version3 = 2722 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL451
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0350' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of sp3res.dll is less than 5.0.2195.6713

	(SELECT 'the version of sp3res.dll is less than 5.0.2195.6713' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\sp3res.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6713))))))

AND EXISTS

	-- the version of umandlg.dll is less than 1.0.0.3

	(SELECT 'the version of umandlg.dll is less than 1.0.0.3' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\umandlg.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 1 OR (Version1 = 1 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3))))))

AND NOT EXISTS

	-- Patch KB822679 Installed

	(SELECT 'Patch KB822679 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB822679' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL459
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0816' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.3790.94

	(SELECT 'the version of mshtml.dll is less than 6.0.3790.94' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 94))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Hotfix key)

	(SELECT 'the patch q824145 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824245' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL471
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1186' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Installed
	(SELECT 'Internet Explorer 5.01 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.3800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.6307')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2920.0000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3103.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3105.0106')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3314.2101')

	OR EXISTS
		-- Internet Explorer 5.01 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3315.1000'))

AND EXISTS

	-- File %windir%\system32\mshtml.dll version is less than 5.0.3510.1100

	(SELECT 'File %windir%\system32\mshtml.dll version is less than 5.0.3510.1100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3510 OR Version3 = 3510 AND
		Version4 < 1100))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL472
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2734.1600

	(SELECT 'the version of mshtml.dll is less than 6.0.2734.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2734 OR Version3 = 2734 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL477
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0904' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Exchange Server 2003 (gold edition) is installed

	(SELECT 'Exchange Server 2003 (gold edition) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup' AND
		EntryName = 'Services Version' AND
		EntryValue = '65')

AND EXISTS

	-- the version of exprox.dll is less than 6.5.6980.57

	(SELECT 'the version of exprox.dll is less than 6.5.6980.57' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\bin\exprox.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup' AND
			EntryName = 'Services') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 6980 OR Version3 = 6980 AND
		Version4 < 57))))))

AND NOT EXISTS

	-- the patch KB832759 is installed

	(SELECT 'the patch KB832759 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Exchange Server 2003\SP1\832759')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- this is a front-end server providing Outlook Web Access

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- the back-end server is Exchange Server 2003 running on Windows 2003

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND NOT EXISTS

	-- HTTP connection reuse is disabled

	(SELECT 'HTTP connection reuse is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\MSExchangeWEB\DAV' AND
		EntryName = 'ReuseConnections' AND
		EntryValue = '0')

AND EXISTS

	-- Kerberos is disabled on the virtual server that hosts OWA on the Exchange Server 2003 back-end server

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL478
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0819' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- ISA Server 2000 is installed

	(SELECT 'ISA Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
		EntryName = 'VersionMajor' AND
		EntryValue = '3')

AND EXISTS

	-- the version of h32fltr.dll is less than 3.0.1200.291

	(SELECT 'the version of h32fltr.dll is less than 3.0.1200.291' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'h323fltr.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc' AND
			EntryName = 'InstallDirectory') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1200 OR Version3 = 1200 AND
		Version4 < 291))))))

AND NOT EXISTS

	-- the patch q816458 is installed

	(SELECT 'the patch q816458 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\291' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- H.323 filter is enabled

	(SELECT 'H.323 filter is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\Arrays\{%}\Extensions\Proxy-Plugins\{FE440D49-AB26-11D2-A101-00C04FB6CFB6}' AND
		EntryName = 'msFPCEnabled' AND
		EntryValue = '1')

AND EXISTS

	-- Microsoft Firewall Service is not disabled

	(SELECT 'Microsoft Firewall Service is not disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Fwsrv' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL479
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0816' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2734.1600

	(SELECT 'the version of mshtml.dll is less than 6.0.2734.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2734 OR Version3 = 2734 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL483
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0224' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\ssinc.dll version is less than 5.0.2195.6624

	(SELECT 'File %windir%\system32\inetsrv\ssinc.dll version is less than 5.0.2195.6624' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\ssinc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6624))))))

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL484
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0186' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- MDAC 2.6 is installed

	(SELECT 'MDAC 2.6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.6%')

AND EXISTS

	-- the version of sqlisapi.dll is less than 2000.80.309.0

	(SELECT 'the version of sqlisapi.dll is less than 2000.80.309.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System\Ole DB folder\sqlisapi.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = '' AND
			EntryName = '') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 309 OR Version3 = 309 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.760.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.760.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 760 OR Version3 = 760 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL489
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0186' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 installed

	(SELECT 'SQL Server 2000 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- MDAC 2.7 (RTM) is installed

	(SELECT 'MDAC 2.7 (RTM) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.70%')

AND EXISTS

	-- the version of sqlisapi.dll is less than 2000.80.309.0

	(SELECT 'the version of sqlisapi.dll is less than 2000.80.309.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System\Ole DB folder\sqlisapi.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = '' AND
			EntryName = '') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 309 OR Version3 = 309 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.760.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.760.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 760 OR Version3 = 760 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL490
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1025' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3526.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3526.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3526 OR Version3 = 3526 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL491
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1025' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3526.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3526.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3526 OR Version3 = 3526 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL494
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0605' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of rpcrt4.dll is less than 5.0.2195.6802

	(SELECT 'the version of rpcrt4.dll is less than 5.0.2195.6802' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6802))))))

AND NOT EXISTS

	-- the patch kb824146 is installed (Hotfix key)

	(SELECT 'the patch kb824146 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB824146' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- DCOM is enabled on systems with SP3 or later
	(SELECT 'DCOM is enabled on systems with SP3 or later' FROM Placeholder WHERE

	EXISTS
		-- Win2K/XP/2003 service pack 3 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

	AND EXISTS
		-- DCOM is enabled

		(SELECT 'DCOM is enabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
			EntryName = 'EnableDCOM' AND
			EntryValue = 'Y'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL495
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1186' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4922.900

	(SELECT 'the version of mshtml.dll is less than 5.50.4922.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4922 OR Version3 = 4922 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL500
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-0045' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- For Windows NT 4.0 Workstation, Server and Enterprise Edition
	(SELECT 'For Windows NT 4.0 Workstation, Server and Enterprise Edition' FROM Placeholder WHERE

	EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7064))))))

	AND NOT EXISTS
		-- Windows NT 4.0 Security Roll-up Package

		(SELECT 'Windows NT 4.0 Security Roll-up Package' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q299444' AND
			EntryName = 'Installed' AND
			EntryValue = '1'))

AND EXISTS

	-- For Terminal Server
	(SELECT 'For Terminal Server' FROM Placeholder WHERE

	EXISTS
		-- this is an NT Terminal Server

		(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductSuite' AND
			EntryValue = 'Terminal Server')

	AND EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7097)))))))

AND NOT EXISTS

	-- Patch Q265714 Installed

	(SELECT 'Patch Q265714 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q265714' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- RAS Enabled

	(SELECT 'RAS Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RasMan' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL507
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0566' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2743.600

	(SELECT 'the version of mshtml.dll is less than 6.00.2743.600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2743 OR Version3 = 2743 AND
		Version4 < 600))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL508
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0817' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL509
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1048' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3819.300

	(SELECT 'the version of mshtml.dll is less than 5.00.3819.300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3819 OR Version3 = 3819 AND
		Version4 < 300))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL510
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1025' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3813.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3813.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3813 OR Version3 = 3813 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL511
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1025' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4937.800

	(SELECT 'the version of mshtml.dll is less than 5.50.4937.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4937 OR Version3 = 4937 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL512
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1025' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2737.800

	(SELECT 'the version of mshtml.dll is less than 6.00.2737.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2737 OR Version3 = 2737 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL513
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1025' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2800.1400

	(SELECT 'the version of mshtml.dll is less than 6.00.2800.1400' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1400))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL515
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0566' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3532.300

	(SELECT 'the version of mshtml.dll is less than 5.0.3532.300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3532 OR Version3 = 3532 AND
		Version4 < 300))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL517
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1048' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.3790.191

	(SELECT 'the version of mshtml.dll is less than 6.00.3790.191' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 191))))))

AND NOT EXISTS

	-- the patch kb867801 is installed (Hotfix key)

	(SELECT 'the patch kb867801 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB867801' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL519
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0549' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2743.600

	(SELECT 'the version of mshtml.dll is less than 6.00.2743.600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2743 OR Version3 = 2743 AND
		Version4 < 600))))))

AND NOT EXISTS

	-- the patch kb832894 is installed (Installed Components key)

	(SELECT 'the patch kb832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2298d453-bcae-4519-bf33-1cbf3faf1524}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL520
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0817' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3523.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3523.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3523 OR Version3 = 3523 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL525
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0903' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- MDAC 2.5 is installed

	(SELECT 'MDAC 2.5 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.5%')

AND EXISTS

	-- the version of odbcbcp.dll is less than 3.70.11.46

	(SELECT 'the version of odbcbcp.dll is less than 3.70.11.46' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 70 OR (Version2 = 70 AND
		(Version3 < 11 OR Version3 = 11 AND
		Version4 < 46))))))

AND EXISTS

	-- the version of sqlsrv32.dll is less than 3.70.11.46

	(SELECT 'the version of sqlsrv32.dll is less than 3.70.11.46' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 70 OR (Version2 = 70 AND
		(Version3 < 11 OR Version3 = 11 AND
		Version4 < 46))))))

AND NOT EXISTS

	-- the patch q832483 is installed

	(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q832483' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL526
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1025' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.3790.118

	(SELECT 'the version of mshtml.dll is less than 6.00.3790.118' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 118))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Hotfix key)

	(SELECT 'the patch q832894 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB832894' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL527
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3526.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3526.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3526 OR Version3 = 3526 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL529
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3526.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3526.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3526 OR Version3 = 3526 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL530
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3813.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3813.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3813 OR Version3 = 3813 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL531
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4937.800

	(SELECT 'the version of mshtml.dll is less than 5.50.4937.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4937 OR Version3 = 4937 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL532
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2737.800

	(SELECT 'the version of mshtml.dll is less than 6.00.2737.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2737 OR Version3 = 2737 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL534
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2800.1400

	(SELECT 'the version of mshtml.dll is less than 6.00.2800.1400' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1400))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL542
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1185' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4922.900

	(SELECT 'the version of mshtml.dll is less than 5.50.4922.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4922 OR Version3 = 4922 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL543
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0817' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2734.1600

	(SELECT 'the version of mshtml.dll is less than 6.0.2734.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2734 OR Version3 = 2734 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL548
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0817' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3810.1700

	(SELECT 'the version of mshtml.dll is less than 5.0.3810.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3810 OR Version3 = 3810 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL549
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0817' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4934.1600

	(SELECT 'the version of mshtml.dll is less than 5.50.4934.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4934 OR Version3 = 4934 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL553
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0903' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- MDAC 2.6 is installed

	(SELECT 'MDAC 2.6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.6%')

AND EXISTS

	-- the version of odbcbcp.dll is less than 2000.80.747.0

	(SELECT 'the version of odbcbcp.dll is less than 2000.80.747.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 747 OR Version3 = 747 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlsrv32.dll is less than 2000.80.747.0

	(SELECT 'the version of sqlsrv32.dll is less than 2000.80.747.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 747 OR Version3 = 747 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- the patch q832483 is installed

	(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q832483' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL556
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0817' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1276

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1276' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1276))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL566
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0817' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.3790.94

	(SELECT 'the version of mshtml.dll is less than 6.0.3790.94' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 94))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Hotfix key)

	(SELECT 'the patch q824145 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824245' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL575
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0812' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of wkssvc.dll is less than 5.00.2195.6862

	(SELECT 'the version of wkssvc.dll is less than 5.00.2195.6862' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wkssvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6862))))))

AND NOT EXISTS

	-- the patch q828748 is installed (Hotfix key)

	(SELECT 'the patch q828748 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828749' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the workstation service is enabled

	(SELECT 'the workstation service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\lanmanworkstation' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL582
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1258' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of msjava.dll is less than 5.0.3809.0

	(SELECT 'the version of msjava.dll is less than 5.0.3809.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msjava.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3809 OR Version3 = 3809 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL585
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0820' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Word 97 is installed

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- the version of winword.exe is less than 8.0.0.9315

	(SELECT 'the version of winword.exe is less than 8.0.0.9315' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\winword.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe' AND
			EntryName = 'Path') AND
		(Version1 < 8 OR (Version1 = 8 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 9315))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL586
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0820' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Word 98 is installed

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- the version of winword.exe is less than 8.0.0.9716

	(SELECT 'the version of winword.exe is less than 8.0.0.9716' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\winword.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe' AND
			EntryName = 'Path') AND
		(Version1 < 8 OR (Version1 = 8 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 9716))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL588
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0823' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.3790.94

	(SELECT 'the version of mshtml.dll is less than 6.0.3790.94' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 94))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Hotfix key)

	(SELECT 'the patch q824145 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB824245' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL591
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0824' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of shtml.dll is less than 4.0.2.7523

	(SELECT 'the version of shtml.dll is less than 4.0.2.7523' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\isapi\shtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'CommonFilesDir') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 02 OR Version3 = 02 AND
		Version4 < 7523))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (WinNT)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (WinNT)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\Setup Packages' AND
		EntryName = 'FrontPage 2000 Server Extensions SR')

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL606
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0824' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of shtml.dll is less than 4.0.2.7523

	(SELECT 'the version of shtml.dll is less than 4.0.2.7523' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\isapi\shtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'CommonFilesDir') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 02 OR Version3 = 02 AND
		Version4 < 7523))))))

AND NOT EXISTS

	-- the patch q810217 is installed (Hotfix key)

	(SELECT 'the patch q810217 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB810217' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (2K, XP)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Setup\OC Manager\Subcomponents' AND
		EntryName = 'fp_extensions' AND
		EntryValue = '1')

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL625
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0824' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT, 2000, or XP is installed
	(SELECT 'Windows NT, 2000, or XP is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	OR EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	OR EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1'))

AND EXISTS

	-- a vulnerable version of shtml.dll exists (FPSE 2002 or SPTS 2003)

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)

	(SELECT 'FrontPage Server Extensions 2002 are enabled (NT, 2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\5.0\Setup Packages' AND
		EntryName = 'Microsoft FrontPage Server Extensions 2002')

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL629
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.3790.118

	(SELECT 'the version of mshtml.dll is less than 6.00.3790.118' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 118))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Hotfix key)

	(SELECT 'the patch q832894 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB832894' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL630
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3315.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3526.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3526.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3526 OR Version3 = 3526 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL636
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0821' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Excel 2000 is installed

	(SELECT 'Excel 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\9.0\Excel\InstallRoot')

AND EXISTS

	-- the version of excel.exe is less than 9.0.0.8216

	(SELECT 'the version of excel.exe is less than 9.0.0.8216' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\excel.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Excel.exe' AND
			EntryName = 'Path') AND
		(Version1 < 9 OR (Version1 = 9 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 8216))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL643
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3526.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3526.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3526 OR Version3 = 3526 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL653
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0818' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of msasn1.dll is less than 5.0.2195.6823

	(SELECT 'the version of msasn1.dll is less than 5.0.2195.6823' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msasn1.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6823))))))

AND NOT EXISTS

	-- the patch kb828028 is installed

	(SELECT 'the patch kb828028 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828028' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL668
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0820' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Word 2002 is installed

	(SELECT 'Word 2002 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\10.0\Word\InstallRoot')

AND EXISTS

	-- the version of winword.exe is less than 10.0.5815.0

	(SELECT 'the version of winword.exe is less than 10.0.5815.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\winword.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Winword.exe' AND
			EntryName = 'Path') AND
		(Version1 < 10 OR (Version1 = 10 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 5815 OR Version3 = 5815 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL675
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0821' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Excel 97 is installed

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- the version of excel.exe is less than 8.00.01.9904

	(SELECT 'the version of excel.exe is less than 8.00.01.9904' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\excel.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Excel.exe' AND
			EntryName = 'Path') AND
		(Version1 < 8 OR (Version1 = 8 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 01 OR Version3 = 01 AND
		Version4 < 9904))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL681
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1230' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of user32.dll is less than 4.0.1381.7177

	(SELECT 'the version of user32.dll is less than 4.0.1381.7177' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\user32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7177))))))

AND EXISTS

	-- the version of gdi32.dll is less than 4.0.1381.7177

	(SELECT 'the version of gdi32.dll is less than 4.0.1381.7177' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\gdi32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7177))))))

AND EXISTS

	-- the version of winsrv.dll is less than 4.0.1381.7202

	(SELECT 'the version of winsrv.dll is less than 4.0.1381.7202' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\winsrv.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7202))))))

AND EXISTS

	-- the version of win32k.sys is less than 4.0.1381.7207

	(SELECT 'the version of win32k.sys is less than 4.0.1381.7207' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\win32k.sys' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7207))))))

AND NOT EXISTS

	-- Patch Q328310 Installed

	(SELECT 'Patch Q328310 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q328310' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL687
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 4 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 4 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3700.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.00.3813.800

	(SELECT 'the version of mshtml.dll is less than 5.00.3813.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3813 OR Version3 = 3813 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL689
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4937.800

	(SELECT 'the version of mshtml.dll is less than 5.50.4937.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4937 OR Version3 = 4937 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL690
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1188' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4922.900

	(SELECT 'the version of mshtml.dll is less than 5.50.4922.900' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4922 OR Version3 = 4922 AND
		Version4 < 900))))))

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL695
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0821' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Excel 2002 is installed

	(SELECT 'Excel 2002 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\10.0\Excel\InstallRoot')

AND EXISTS

	-- the version of excel.exe is less than 10.0.5815.0

	(SELECT 'the version of excel.exe is less than 10.0.5815.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\excel.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Excel.exe' AND
			EntryName = 'Path') AND
		(Version1 < 10 OR (Version1 = 10 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 5815 OR Version3 = 5815 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL699
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0822' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of fp30reg.dll or fp4areg.dll exists
	(SELECT 'a vulnerable version of fp30reg.dll or fp4areg.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of fp4areg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp4areg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp4areg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523))))))

	OR EXISTS
		-- the version of fp30reg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp30reg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp30reg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523)))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (WinNT)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (WinNT)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\Setup Packages' AND
		EntryName = 'FrontPage 2000 Server Extensions SR')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL704
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0825' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 Server is installed
	(SELECT 'Windows 2000 Server is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Windows server product option
		(SELECT 'Windows server product option' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Server (stand-alone)

			(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%ServerNT%')

		OR EXISTS
			-- this is an NT Server (domain controller)

			(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%LanmanNT%')))

AND EXISTS

	-- the version of wins.exe is less than 5.0.2195.6870

	(SELECT 'the version of wins.exe is less than 5.0.2195.6870' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wins.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6870))))))

AND NOT EXISTS

	-- the patch kb830352 is installed (Hotfix key)

	(SELECT 'the patch kb830352 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB830352' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the wins service is enabled

	(SELECT 'the wins service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\wins' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL733
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0823' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2734.1600

	(SELECT 'the version of mshtml.dll is less than 6.0.2734.1600' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2734 OR Version3 = 2734 AND
		Version4 < 1600))))))

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL743
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0822' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- a vulnerable version of fp30reg.dll or fp4areg.dll exists
	(SELECT 'a vulnerable version of fp30reg.dll or fp4areg.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of fp4areg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp4areg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp4areg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523))))))

	OR EXISTS
		-- the version of fp30reg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp30reg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp30reg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523)))))))

AND NOT EXISTS

	-- the patch q810217 is installed (Hotfix key)

	(SELECT 'the patch q810217 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB810217' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (2K, XP)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Setup\OC Manager\Subcomponents' AND
		EntryName = 'fp_extensions' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL745
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2737.800

	(SELECT 'the version of mshtml.dll is less than 6.00.2737.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2737 OR Version3 = 2737 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL751
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0903' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- MDAC 2.7 is installed and a vulnerable version of sqlsrv32.dll and odbcbcp.dll exists
	(SELECT 'MDAC 2.7 is installed and a vulnerable version of sqlsrv32.dll and odbcbcp.dll exists' FROM Placeholder WHERE

	EXISTS
		-- MDAC 2.7 (RTM) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9002.0
		(SELECT 'MDAC 2.7 (RTM) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9002.0' FROM Placeholder WHERE

		EXISTS
			-- MDAC 2.7 (RTM) is installed

			(SELECT 'MDAC 2.7 (RTM) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
				EntryName = 'FullInstallVer' AND
				EntryValue LIKE '2.70%')

		AND EXISTS
			-- the version of sqlsrv32.dll is less than 2000.81.9002.0

			(SELECT 'the version of sqlsrv32.dll is less than 2000.81.9002.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9002 OR Version3 = 9002 AND
				Version4 < 0))))))

		AND EXISTS
			-- the version of odbcbcp.dll is less than 2000.81.9002.0

			(SELECT 'the version of odbcbcp.dll is less than 2000.81.9002.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9002 OR Version3 = 9002 AND
				Version4 < 0)))))))

	OR EXISTS
		-- MDAC 2.7 (SP1) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9042.0
		(SELECT 'MDAC 2.7 (SP1) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9042.0' FROM Placeholder WHERE

		EXISTS
			-- MDAC 2.7 (SP1) is installed

			(SELECT 'MDAC 2.7 (SP1) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
				EntryName = 'FullInstallVer' AND
				EntryValue LIKE '2.71%')

		AND EXISTS
			-- the version of sqlsrv32.dll is less than 2000.81.9042.0

			(SELECT 'the version of sqlsrv32.dll is less than 2000.81.9042.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9042 OR Version3 = 9042 AND
				Version4 < 0))))))

		AND EXISTS
			-- the version of odbcbcp.dll is less than 2000.81.9042.0

			(SELECT 'the version of odbcbcp.dll is less than 2000.81.9042.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9042 OR Version3 = 9042 AND
				Version4 < 0))))))))

AND NOT EXISTS

	-- the patch q832483 is installed

	(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q832483' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL762
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0824' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000, XP, or 2003 is installed
	(SELECT 'Windows 2000, XP, or 2003 is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	OR EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	OR EXISTS
		-- Windows Server 2003 is installed

		(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.2'))

AND EXISTS

	-- a vulnerable version of shtml.dll exists (FPSE 2002 or SPTS 2003)

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SharePoint Team Services are enabled (2K, XP, 2003)

	(SELECT 'SharePoint Team Services are enabled (2K, XP, 2003)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\Setup Packages' AND
		EntryName = 'SharePoint' AND
		EntryValue = 'Installed')

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL774
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.2800.1400

	(SELECT 'the version of mshtml.dll is less than 6.00.2800.1400' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1400))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL775
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0903' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- MDAC 2.8 (RTM) is installed

	(SELECT 'MDAC 2.8 (RTM) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.8%')

AND EXISTS

	-- the version of odbcbcp.dll is less than 2000.85.1025.0

	(SELECT 'the version of odbcbcp.dll is less than 2000.85.1025.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 85 OR (Version2 = 85 AND
		(Version3 < 1025 OR Version3 = 1025 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlsrv32.dll is less than 2000.85.1025.0

	(SELECT 'the version of sqlsrv32.dll is less than 2000.85.1025.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 85 OR (Version2 = 85 AND
		(Version3 < 1025 OR Version3 = 1025 AND
		Version4 < 0))))))

AND EXISTS

	-- the patch q832483 is not installed
	(SELECT 'the patch q832483 is not installed' FROM Placeholder WHERE

	EXISTS
		-- 32-bit edition of windows and patch q832483 is not installed
		(SELECT '32-bit edition of windows and patch q832483 is not installed' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND NOT EXISTS
			-- the patch q832483 is installed

			(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q832483' AND
				EntryName = 'IsInstalled' AND
				EntryValue = '1'))

	OR EXISTS
		-- 64-bit edition of windows and patch q832483 is not installed
		(SELECT '64-bit edition of windows and patch q832483 is not installed' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND NOT EXISTS
			-- the patch q832483 is installed

			(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB832483' AND
				EntryName = 'Installed' AND
				EntryValue = '1')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL794
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0010' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of jscript.dll is less than 5.1.0.8513

	(SELECT 'the version of jscript.dll is less than 5.1.0.8513' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\jscript.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 8513))))))

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND NOT EXISTS

	-- the patch js56nen.exe (5.1.0.8513 version) is installed

	(SELECT 'the patch js56nen.exe (5.1.0.8513 version) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{4f645220-306d-11d2-995d-00c04f98bbc9}' AND
		EntryName = 'Version' AND
		EntryValue = '5,1,0,8513')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- active scripting is enabled
	(SELECT 'active scripting is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and active scripting is enabled
		(SELECT 'current user settings are being used and active scripting is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and active scripting is enabled
		(SELECT 'local machine settings are being used and active scripting is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL795
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0010' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of jscript.dll is less than 5.5.0.8513

	(SELECT 'the version of jscript.dll is less than 5.5.0.8513' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\jscript.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 8513))))))

AND NOT EXISTS

	-- Windows 2000 Service Pack 4 (or later) is installed
	(SELECT 'Windows 2000 Service Pack 4 (or later) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND NOT EXISTS

	-- the patch js56nen.exe (5.5.0.8513 version) is installed

	(SELECT 'the patch js56nen.exe (5.5.0.8513 version) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{4f645220-306d-11d2-995d-00c04f98bbc9}' AND
		EntryName = 'Version' AND
		EntryValue = '5,5,0,8513')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- active scripting is enabled
	(SELECT 'active scripting is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and active scripting is enabled
		(SELECT 'current user settings are being used and active scripting is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and active scripting is enabled
		(SELECT 'local machine settings are being used and active scripting is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL796
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0818' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of msasn1.dll is less than 5.0.2195.6824

	(SELECT 'the version of msasn1.dll is less than 5.0.2195.6824' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msasn1.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6824))))))

AND NOT EXISTS

	-- the patch kb828028 is installed

	(SELECT 'the patch kb828028 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828028' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL797
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0818' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of msasn1.dll exists
	(SELECT 'a vulnerable version of msasn1.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and msasn1.dll is less than 5.1.2600.119
		(SELECT 'no service pack is installed and msasn1.dll is less than 5.1.2600.119' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of msasn1.dll is less than 5.1.2600.119

			(SELECT 'the version of msasn1.dll is less than 5.1.2600.119' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msasn1.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 119)))))))

	OR EXISTS
		-- service pack 1 is installed and msasn1.dll is less than 5.1.2600.1274
		(SELECT 'service pack 1 is installed and msasn1.dll is less than 5.1.2600.1274' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of msasn1.dll is less than 5.1.2600.1274

			(SELECT 'the version of msasn1.dll is less than 5.1.2600.1274' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msasn1.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1274))))))))

AND NOT EXISTS

	-- the patch kb828028 is installed

	(SELECT 'the patch kb828028 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828028' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL799
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0818' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of msasn1.dll is less than 5.2.3790.88

	(SELECT 'the version of msasn1.dll is less than 5.2.3790.88' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msasn1.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 88))))))

AND NOT EXISTS

	-- the patch kb828028 is installed

	(SELECT 'the patch kb828028 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828028' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL800
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0825' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT Server 4.0 is installed
	(SELECT 'Windows NT Server 4.0 is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	AND EXISTS
		-- Windows server product option
		(SELECT 'Windows server product option' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Server (stand-alone)

			(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%ServerNT%')

		OR EXISTS
			-- this is an NT Server (domain controller)

			(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%LanmanNT%')))

AND EXISTS

	-- the version of wins.exe is less than 4.0.1381.7255

	(SELECT 'the version of wins.exe is less than 4.0.1381.7255' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wins.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7255))))))

AND NOT EXISTS

	-- the patch kb830352 is installed (Hotfix key)

	(SELECT 'the patch kb830352 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB830352' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the wins service is enabled

	(SELECT 'the wins service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\wins' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL801
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0825' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT Server 4.0, Terminal Server Edition is installed
	(SELECT 'Windows NT Server 4.0, Terminal Server Edition is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	AND EXISTS
		-- this is an NT Terminal Server

		(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductSuite' AND
			EntryValue = 'Terminal Server'))

AND EXISTS

	-- the version of wins.exe is less than 4.0.1381.33554

	(SELECT 'the version of wins.exe is less than 4.0.1381.33554' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wins.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 33554))))))

AND NOT EXISTS

	-- the patch kb830352 is installed (Hotfix key)

	(SELECT 'the patch kb830352 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB830352' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the wins service is enabled

	(SELECT 'the wins service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\wins' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL802
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0825' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of wins.exe is less than 5.2.3790.99

	(SELECT 'the version of wins.exe is less than 5.2.3790.99' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wins.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 99))))))

AND NOT EXISTS

	-- the patch kb830352 is installed (Hotfix key)

	(SELECT 'the patch kb830352 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB830352' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the wins service is enabled

	(SELECT 'the wins service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\wins' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL805
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1026' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.00.3790.118

	(SELECT 'the version of mshtml.dll is less than 6.00.3790.118' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 118))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Hotfix key)

	(SELECT 'the patch q832894 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB832894' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL842
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0905' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Media Services 4.1 is installed on Microsoft Windows 2000 Server
	(SELECT 'Windows Media Services 4.1 is installed on Microsoft Windows 2000 Server' FROM Placeholder WHERE

	EXISTS
		-- Windows Media Services 4.1 is installed

		(SELECT 'Windows Media Services 4.1 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NetShow' AND
			EntryName = 'Version' AND
			EntryValue = '4.1')

	AND EXISTS
		-- Windows 2000 Server is installed
		(SELECT 'Windows 2000 Server is installed' FROM Placeholder WHERE

		EXISTS
			-- Windows 2000 is installed

			(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CurrentVersion' AND
				EntryValue = '5.0')

		AND EXISTS
			-- Windows server product option
			(SELECT 'Windows server product option' FROM Placeholder WHERE

			EXISTS
				-- this is an NT Server (stand-alone)

				(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%ServerNT%')

			OR EXISTS
				-- this is an NT Server (domain controller)

				(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%LanmanNT%'))))

AND EXISTS

	-- the version of nscm.exe is less than 4.1.0.3934

	(SELECT 'the version of nscm.exe is less than 4.1.0.3934' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Windows Media\Server\nscm.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3934))))))

AND EXISTS

	-- the version of nspmon.exe is less than 4.1.0.3934

	(SELECT 'the version of nspmon.exe is less than 4.1.0.3934' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Windows Media\Server\nspmon.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3934))))))

AND NOT EXISTS

	-- the patch kb832359 is installed

	(SELECT 'the patch kb832359 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Services\KB832359' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- configured to only offer streaming media over unicast

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND NOT EXISTS

	-- the Windows Media Station service is disabled

	(SELECT 'the Windows Media Station service is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\nsstation' AND
		EntryName = 'Start' AND
		EntryValue != '4')

AND NOT EXISTS

	-- the Windows Media Monitor service is disabled

	(SELECT 'the Windows Media Monitor service is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Services\KB832359' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL843
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0121' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Outlook 2002 is installed

	(SELECT 'Outlook 2002 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\10.0\Outlook\InstallRoot')

AND EXISTS

	-- the version of outlook.exe is less than 10.00.5709.0000

	(SELECT 'the version of outlook.exe is less than 10.00.5709.0000' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'outlook.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths' AND
			EntryName = 'OUTLOOK.EXE') AND
		(Version1 < 10 OR (Version1 = 10 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 5709 OR Version3 = 5709 AND
		Version4 < 0000))))))

AND NOT EXISTS

	-- the patch kb828040 is installed

	(SELECT 'the patch kb828040 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{90280409-6000-11D3-8CFE-0050048383C9}' AND
		EntryName = 'DisplayVersion' AND
		EntryValue = '10.0.4333.0')

AND NOT EXISTS

	-- Microsoft Office XP Service Pack 3 is installed

	(SELECT 'Microsoft Office XP Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{90280409-6000-11D3-8CFE-0050048383C9}' AND
		EntryName = 'DisplayVersion' AND
		EntryValue = '10.0.6626.0')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL844
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0122' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Microsoft MSN Messenger 6.0 or 6.1 (but less than 6.1.0211) is installed
	(SELECT 'Microsoft MSN Messenger 6.0 or 6.1 (but less than 6.1.0211) is installed' FROM Placeholder WHERE

	EXISTS
		-- the version of msgsc.dll is greater than 6.0.0.0

		(SELECT 'the version of msgsc.dll is greater than 6.0.0.0' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\MSN Messenger\msgsc.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'ProgramFilesDir') AND
			(Version1 > 6 OR (Version1 = 6 AND
			(Version2 > 0 OR (Version2 = 0 AND
			(Version3 > 0 OR Version3 = 0 AND
			Version4 > 0))))))

	AND EXISTS
		-- the version of msgsc.dll is less than 6.1.0.211

		(SELECT 'the version of msgsc.dll is less than 6.1.0.211' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\MSN Messenger\msgsc.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'ProgramFilesDir') AND
			(Version1 < 6 OR (Version1 = 6 AND
			(Version2 < 1 OR (Version2 = 1 AND
			(Version3 < 0 OR Version3 = 0 AND
			Version4 < 211)))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL882
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0380' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Outlook Express 5.5 SP2 is installed

	(SELECT 'Outlook Express 5.5 SP2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Outlook Express\Version Info' AND
		EntryName = 'Current' AND
		EntryValue = '5,50,4807,1700')

AND EXISTS

	-- the version of inetcomm.dll is less than 5.50.4939.300

	(SELECT 'the version of inetcomm.dll is less than 5.50.4939.300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetcomm.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4939 OR Version3 = 4939 AND
		Version4 < 300))))))

AND NOT EXISTS

	-- the patch kb837009 is installed (installed components key)

	(SELECT 'the patch kb837009 is installed (installed components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2cc9d512-6db6-4f1c-8979-9a41fae88de0}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL883
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0533' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of lsasrv.dll is less than 5.0.2195.6902

	(SELECT 'the version of lsasrv.dll is less than 5.0.2195.6902' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\lsasrv.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6902))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL885
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0120' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of schannel.dll is less than 5.2.3790.132

	(SELECT 'the version of schannel.dll is less than 5.2.3790.132' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 132))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL886
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0120' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of schannel.dll exists
	(SELECT 'a vulnerable version of schannel.dll exists' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of schannel.dll exists
		(SELECT '32-bit version of Windows and a vulnerable version of schannel.dll exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of schannel.dll exists depending on service pack level
			(SELECT 'a vulnerable version of schannel.dll exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- no service pack is installed and schannel.dll is less than 5.1.2600.136
				(SELECT 'no service pack is installed and schannel.dll is less than 5.1.2600.136' FROM Placeholder WHERE

				NOT EXISTS
					-- a Win2K/XP/2003 service pack is installed

					(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion')

				AND EXISTS
					-- the version of schannel.dll is less than 5.1.2600.136

					(SELECT 'the version of schannel.dll is less than 5.1.2600.136' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 136)))))))

			OR EXISTS
				-- service pack 1 is installed and schannel.dll is less than 5.1.2600.1347
				(SELECT 'service pack 1 is installed and schannel.dll is less than 5.1.2600.1347' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 1 is installed

					(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 1')

				AND EXISTS
					-- the version of schannel.dll is less than 5.1.2600.1347

					(SELECT 'the version of schannel.dll is less than 5.1.2600.1347' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1347)))))))))

	OR EXISTS
		-- 64-bit version of Windows and schannel.dll is less than 5.1.2600.1347
		(SELECT '64-bit version of Windows and schannel.dll is less than 5.1.2600.1347' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of schannel.dll is less than 5.1.2600.1347

			(SELECT 'the version of schannel.dll is less than 5.1.2600.1347' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1347))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL889
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0719' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of schannel.dll exists
	(SELECT 'a vulnerable version of schannel.dll exists' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of schannel.dll exists
		(SELECT '32-bit version of Windows and a vulnerable version of schannel.dll exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of schannel.dll exists depending on service pack level
			(SELECT 'a vulnerable version of schannel.dll exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- no service pack is installed and schannel.dll is less than 5.1.2600.136
				(SELECT 'no service pack is installed and schannel.dll is less than 5.1.2600.136' FROM Placeholder WHERE

				NOT EXISTS
					-- a Win2K/XP/2003 service pack is installed

					(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion')

				AND EXISTS
					-- the version of schannel.dll is less than 5.1.2600.136

					(SELECT 'the version of schannel.dll is less than 5.1.2600.136' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 136)))))))

			OR EXISTS
				-- service pack 1 is installed and schannel.dll is less than 5.1.2600.1347
				(SELECT 'service pack 1 is installed and schannel.dll is less than 5.1.2600.1347' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 1 is installed

					(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 1')

				AND EXISTS
					-- the version of schannel.dll is less than 5.1.2600.1347

					(SELECT 'the version of schannel.dll is less than 5.1.2600.1347' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1347)))))))))

	OR EXISTS
		-- 64-bit version of Windows and schannel.dll is less than 5.1.2600.1347
		(SELECT '64-bit version of Windows and schannel.dll is less than 5.1.2600.1347' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of schannel.dll is less than 5.1.2600.1347

			(SELECT 'the version of schannel.dll is less than 5.1.2600.1347' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1347))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

AND NOT EXISTS

	-- PCT support is disabled

	(SELECT 'PCT support is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\PCT 1.0\Server' AND
		EntryName = 'Enabled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL890
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0910' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of wintrust.dll is less than 5.131.2195.6824

	(SELECT 'the version of wintrust.dll is less than 5.131.2195.6824' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wintrust.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 131 OR (Version2 = 131 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6824))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL892
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0120' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of schannel.dll is less than 5.1.2195.6899

	(SELECT 'the version of schannel.dll is less than 5.1.2195.6899' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6899))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL893
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0813' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of rpcrt4.dll is less than 5.0.2195.6904

	(SELECT 'the version of rpcrt4.dll is less than 5.0.2195.6904' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6904))))))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL895
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0806' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of msgina.dll exists on NT
	(SELECT 'a vulnerable version of msgina.dll exists on NT' FROM Placeholder WHERE

	EXISTS
		-- non Terminal Server and msgina.dll is less than 4.0.1381.7255
		(SELECT 'non Terminal Server and msgina.dll is less than 4.0.1381.7255' FROM Placeholder WHERE

		NOT EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of msgina.dll is less than 4.0.1381.7255

			(SELECT 'the version of msgina.dll is less than 4.0.1381.7255' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msgina.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7255)))))))

	OR EXISTS
		-- Terminal Server and msgina.dll is less than 4.0.1381.33559
		(SELECT 'Terminal Server and msgina.dll is less than 4.0.1381.33559' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of msgina.dll is less than 4.0.1381.33559

			(SELECT 'the version of msgina.dll is less than 4.0.1381.33559' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msgina.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33559))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- machine is a member of a domain

	(SELECT 'machine is a member of a domain' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Netlogon' AND
		EntryName = 'Start' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL896
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0806' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of msgina.dll is less than 5.1.2600.136

	(SELECT 'the version of msgina.dll is less than 5.1.2600.136' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msjet40.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6895))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- machine is a member of a domain

	(SELECT 'machine is a member of a domain' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Netlogon' AND
		EntryName = 'Start' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL897
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0906' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of mf3216.dll exists on NT
	(SELECT 'a vulnerable version of mf3216.dll exists on NT' FROM Placeholder WHERE

	EXISTS
		-- non Terminal Server and mf3216.dll is less than 4.0.1381.7263
		(SELECT 'non Terminal Server and mf3216.dll is less than 4.0.1381.7263' FROM Placeholder WHERE

		NOT EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of mf3216.dll is less than 4.0.1381.7263

			(SELECT 'the version of mf3216.dll is less than 4.0.1381.7263' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\mf3216.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7263)))))))

	OR EXISTS
		-- NT Terminal Server and mf3216.dll is less than 4.0.1381.33562
		(SELECT 'NT Terminal Server and mf3216.dll is less than 4.0.1381.33562' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of mf3216.dll is less than 4.0.1381.33562

			(SELECT 'the version of mf3216.dll is less than 4.0.1381.33562' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\mf3216.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33562))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL898
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0533' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of lsasrv.dll exists on XP
	(SELECT 'a vulnerable version of lsasrv.dll exists on XP' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of lsasrv.dll exists
		(SELECT '32-bit version of Windows and a vulnerable version of lsasrv.dll exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of lsasrv.dll exists depending on service pack level
			(SELECT 'a vulnerable version of lsasrv.dll exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- no service pack is installed and lsasrv.dll is less than 5.1.2600.134
				(SELECT 'no service pack is installed and lsasrv.dll is less than 5.1.2600.134' FROM Placeholder WHERE

				NOT EXISTS
					-- a Win2K/XP/2003 service pack is installed

					(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion')

				AND EXISTS
					-- the version of lsasrv.dll is less than 5.1.2600.134

					(SELECT 'the version of lsasrv.dll is less than 5.1.2600.134' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\lsasrv.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 134)))))))

			OR EXISTS
				-- service pack 1 is installed and lsasrv.dll is less than 5.1.2600.1361
				(SELECT 'service pack 1 is installed and lsasrv.dll is less than 5.1.2600.1361' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 1 is installed

					(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 1')

				AND EXISTS
					-- the version of lsasrv.dll is less than 5.1.2600.1361

					(SELECT 'the version of lsasrv.dll is less than 5.1.2600.1361' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\lsasrv.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1361)))))))))

	OR EXISTS
		-- 64-bit version of Windows and lsasrv.dll is less than 5.1.2600.1361
		(SELECT '64-bit version of Windows and lsasrv.dll is less than 5.1.2600.1361' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of lsasrv.dll is less than 5.1.2600.1361

			(SELECT 'the version of lsasrv.dll is less than 5.1.2600.1361' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\lsasrv.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1361))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL900
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0813' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND EXISTS

	-- a vulnerable version of rpcrt4.dll exists on XP
	(SELECT 'a vulnerable version of rpcrt4.dll exists on XP' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of rpcrt4.dll exists
		(SELECT '32-bit version of Windows and a vulnerable version of rpcrt4.dll exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of rpcrt4.dll exists depending on service pack level
			(SELECT 'a vulnerable version of rpcrt4.dll exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- no service pack is installed and rpcrt4.dll is less than 5.1.2600.135
				(SELECT 'no service pack is installed and rpcrt4.dll is less than 5.1.2600.135' FROM Placeholder WHERE

				NOT EXISTS
					-- a Win2K/XP/2003 service pack is installed

					(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion')

				AND EXISTS
					-- the version of rpcrt4.dll is less than 5.1.2600.135

					(SELECT 'the version of rpcrt4.dll is less than 5.1.2600.135' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 135)))))))

			OR EXISTS
				-- service pack 1 is installed and rpcrt4.dll is less than 5.1.2600.1361
				(SELECT 'service pack 1 is installed and rpcrt4.dll is less than 5.1.2600.1361' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 1 is installed

					(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 1')

				AND EXISTS
					-- the version of rpcrt4.dll is less than 5.1.2600.1361

					(SELECT 'the version of rpcrt4.dll is less than 5.1.2600.1361' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1361)))))))))

	OR EXISTS
		-- 64-bit version of Windows and rpcrt4.dll is less than 5.1.2600.1361
		(SELECT '64-bit version of Windows and rpcrt4.dll is less than 5.1.2600.1361' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of rpcrt4.dll is less than 5.1.2600.1361

			(SELECT 'the version of rpcrt4.dll is less than 5.1.2600.1361' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1361))))))))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL903
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0719' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of schannel.dll is less than 4.87.1964.1880

	(SELECT 'the version of schannel.dll is less than 4.87.1964.1880' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 87 OR (Version2 = 87 AND
		(Version3 < 1964 OR Version3 = 1964 AND
		Version4 < 1880))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

AND NOT EXISTS

	-- PCT support is disabled

	(SELECT 'PCT support is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\PCT 1.0\Server' AND
		EntryName = 'Enabled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL904
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0907' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of helpctr.exe is less than 5.2.3790.125

	(SELECT 'the version of helpctr.exe is less than 5.2.3790.125' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\helpctr.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 125))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- the HCP Protocol is registered

	(SELECT 'the HCP Protocol is registered' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_CLASSES_ROOT\HCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL907
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0117' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of h323.tsp is less than 5.0.2195.6901

	(SELECT 'the version of h323.tsp is less than 5.0.2195.6901' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\h323.tsp' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6901))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL909
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0507' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\w3svc.dll is less than 4.2.769.1

	(SELECT 'File %windir%\System32\w3svc.dll is less than 4.2.769.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 769 OR Version3 = 769 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL911
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0910' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of wintrust.dll is less than 5.131.1880.14

	(SELECT 'the version of wintrust.dll is less than 5.131.1880.14' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wintrust.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 131 OR (Version2 = 131 AND
		(Version3 < 1880 OR Version3 = 1880 AND
		Version4 < 14))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL912
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0507' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\Msw3prt.dll is less than 5.0.2195.3649

	(SELECT 'File %windir%\System32\Msw3prt.dll is less than 5.0.2195.3649' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Msw3prt.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 3649))))))

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL913
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-1999-0278' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\w3svc.dll is less than 4.0.1381.164

	(SELECT 'File %windir%\System32\w3svc.dll is less than 4.0.1381.164' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 164))))))

AND NOT EXISTS

	-- Service Pack 6 Installed (or later)

	(SELECT 'Service Pack 6 Installed (or later)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 6')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL915
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-1999-0874' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\w3svc.dll is less than 4.0.1381.164

	(SELECT 'File %windir%\System32\w3svc.dll is less than 4.0.1381.164' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 164))))))

AND NOT EXISTS

	-- Service Pack 6 Installed (or later)

	(SELECT 'Service Pack 6 Installed (or later)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 6')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL919
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0533' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of lsasrv.dll is less than 5.2.3790.134

	(SELECT 'the version of lsasrv.dll is less than 5.2.3790.134' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\lsasrv.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 134))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL920
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0002' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Installed
	(SELECT 'Internet Explorer 5.5 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0100')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4134.0600')

	OR EXISTS
		-- Internet Explorer 5.5 Installed

		(SELECT 'Internet Explorer 5.5 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4522.1800'))

AND EXISTS

	-- File %windir%\system32\mshtml.dll version is less than 5.50.4613.1700

	(SELECT 'File %windir%\system32\mshtml.dll version is less than 5.50.4613.1700' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4613 OR Version3 = 4613 AND
		Version4 < 1700))))))

AND NOT EXISTS

	-- Patch Q286045 Installed

	(SELECT 'Patch Q286045 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{A954CDD5-A95F-414F-B3FE-FBEF9D2AECEA}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q295106 Installed

	(SELECT 'Patch Q295106 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{754D29C1-0C97-405F-98D0-21B212CA7FF1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL921
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0727' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2712.0300

	(SELECT 'the version of mshtml.dll is less than 6.0.2712.0300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2712 OR Version3 = 2712 AND
		Version4 < 0300))))))

AND NOT EXISTS

	-- Patch Q313675 Installed

	(SELECT 'Patch Q313675 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{716E024F-7F74-47F3-B93B-9FF7F3CBF94C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q316059.exe Installed

	(SELECT 'Patch Q316059.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319282 Installed

	(SELECT 'Patch Q319282 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Downloads Not Disabled
	(SELECT 'File Downloads Not Disabled' FROM Placeholder WHERE

	EXISTS
		-- Use Machine Settings

		(SELECT 'Use Machine Settings' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
			EntryName = 'Security_HKLM_only' AND
			EntryValue = '1')

	AND EXISTS
		-- File Downloads Allowed In At Least One Zone

		(SELECT 'File Downloads Allowed In At Least One Zone' FROM Windows_RegistryKeys WHERE
			RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
			EntryName = '1803' AND
			EntryValue != '3'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL922
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0344' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4926.2500

	(SELECT 'the version of mshtml.dll is less than 5.50.4926.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4926 OR Version3 = 4926 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL923
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0190' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- File %windir%\system32\mshtml.dll version is less than 6.0.2716.2200

	(SELECT 'File %windir%\system32\mshtml.dll version is less than 6.0.2716.2200' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2716 OR Version3 = 2716 AND
		Version4 < 2200))))))

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL924
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0123' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of msasn1.dll is less than 5.2.3790.139

	(SELECT 'the version of msasn1.dll is less than 5.2.3790.139' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\msasn1.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 139))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL925
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0022' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- File %windir%\system32\mshtml.dll version is less than 6.0.2713.1100

	(SELECT 'File %windir%\system32\mshtml.dll version is less than 6.0.2713.1100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2713 OR Version3 = 2713 AND
		Version4 < 1100))))))

AND NOT EXISTS

	-- Patch Q316059.exe Installed

	(SELECT 'Patch Q316059.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319282 Installed

	(SELECT 'Patch Q319282 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Run ActiveX Controls and Plugins Not Disabled
	(SELECT 'Run ActiveX Controls and Plugins Not Disabled' FROM Placeholder WHERE

	EXISTS
		-- Use Machine Settings

		(SELECT 'Use Machine Settings' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
			EntryName = 'Security_HKLM_only' AND
			EntryValue = '1')

	AND EXISTS
		-- Run ActiveX Controls and Plugins Allowed In At Least One Zone

		(SELECT 'Run ActiveX Controls and Plugins Allowed In At Least One Zone' FROM Windows_RegistryKeys WHERE
			RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
			EntryName = '1200' AND
			EntryValue != '3'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL926
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0113' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4926.2500

	(SELECT 'the version of mshtml.dll is less than 5.50.4926.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4926 OR Version3 = 4926 AND
		Version4 < 2500))))))

AND EXISTS

	-- File %windir%\system32\urlmon.dll version is less than 5.50.4927.2100

	(SELECT 'File %windir%\system32\urlmon.dll version is less than 5.50.4927.2100' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4927 OR Version3 = 4927 AND
		Version4 < 2100))))))

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL927
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2000-0778' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- Win2K/XP/2003 service pack 1 is installed

	(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL929
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0869' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\w3svc.dll is less than 4.2.780.1

	(SELECT 'File %windir%\System32\w3svc.dll is less than 4.2.780.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 780 OR Version3 = 780 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL930
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0869' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\msw3prt.dll is less than 5.0.2195.5807

	(SELECT 'File %windir%\System32\msw3prt.dll is less than 5.0.2195.5807' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\msw3prt.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 58075))))))

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL931
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1180' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\msw3prt.dll is less than 5.0.2195.5807

	(SELECT 'File %windir%\System32\msw3prt.dll is less than 5.0.2195.5807' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\msw3prt.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 58075))))))

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL932
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-1999-0736' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\code.asp is less than 4.0.1381.279

	(SELECT 'File %windir%\System32\code.asp is less than 4.0.1381.279' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\code.asp' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 279))))))

AND NOT EXISTS

	-- Patch Q232449 Installed

	(SELECT 'Patch Q232449 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q232449 ' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL933
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0226' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\w3svc.dll is less than 5.0.2195.6672

	(SELECT 'File %windir%\System32\w3svc.dll is less than 5.0.2195.6672' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6672))))))

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL936
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0227' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\nsiislog.dll is less than 4.1.0.3931

	(SELECT 'File %windir%\System32\nsiislog.dll is less than 4.1.0.3931' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\nsiislog.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3931))))))

AND NOT EXISTS

	-- Patch KB817772 Installed

	(SELECT 'Patch KB817772 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB817772' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch KB822343 Installed

	(SELECT 'Patch KB822343 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB822343' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL938
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0349' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\nsiislog.dll is less than 4.1.0.3932

	(SELECT 'File %windir%\System32\nsiislog.dll is less than 4.1.0.3932' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\nsiislog.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3932))))))

AND NOT EXISTS

	-- Patch KB822343 Installed

	(SELECT 'Patch KB822343 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB822343' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL942
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1181' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\msw3prt.dll is less than 5.0.2195.5807

	(SELECT 'File %windir%\System32\msw3prt.dll is less than 5.0.2195.5807' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\msw3prt.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 58075))))))

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL944
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1181' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\w3svc.dll is less than 4.2.780.1

	(SELECT 'File %windir%\System32\w3svc.dll is less than 4.2.780.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System32\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 780 OR Version3 = 780 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL946
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0117' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of h323.tsp is less than 5.2.3790.132

	(SELECT 'the version of h323.tsp is less than 5.2.3790.132' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\h323.tsp' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 132))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL948
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0309' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4926.2500

	(SELECT 'the version of mshtml.dll is less than 5.50.4926.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4926 OR Version3 = 4926 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL951
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0719' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of schannel.dll is less than 5.1.2195.6899

	(SELECT 'the version of schannel.dll is less than 5.1.2195.6899' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6899))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

AND NOT EXISTS

	-- PCT support is disabled

	(SELECT 'PCT support is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\PCT 1.0\Server' AND
		EntryName = 'Enabled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL952
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-1999-0815' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- File %windir%\system32\snmp.exe is less than 4.0.1381.133

	(SELECT 'File %windir%\system32\snmp.exe is less than 4.0.1381.133' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\snmp.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 133))))))

AND NOT EXISTS

	-- Windows NT Service Pack 5 (or later) installed

	(SELECT 'Windows NT Service Pack 5 (or later) installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 5')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL955
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0116' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of rpcss.dll is less than 5.0.2195.6906

	(SELECT 'the version of rpcss.dll is less than 5.0.2195.6906' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6906))))))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- DCOM is enabled on systems with SP3 or later
	(SELECT 'DCOM is enabled on systems with SP3 or later' FROM Placeholder WHERE

	EXISTS
		-- Win2K/XP/2003 service pack 3 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

	AND EXISTS
		-- DCOM is enabled

		(SELECT 'DCOM is enabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
			EntryName = 'EnableDCOM' AND
			EntryValue = 'Y'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL956
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1041' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- Internet Explorer 5.5 SP2 or Internet Explorer 6.0 SP1 is installed
	(SELECT 'Internet Explorer 5.5 SP2 or Internet Explorer 6.0 SP1 is installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 6 Service Pack 1 is installed

		(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.2800.1106')

	OR EXISTS
		-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

		(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '6.00.3790.0000')

	OR EXISTS
		-- Internet Explorer 5.5 Service Pack 2 is installed

		(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.50.4807.2300'))

AND EXISTS

	-- the version of itss.dll is less than 5.2.3790.185

	(SELECT 'the version of itss.dll is less than 5.2.3790.185' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\itss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 185))))))

AND NOT EXISTS

	-- the patch kb840315 is installed

	(SELECT 'the patch kb840315 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840315' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- HTML Help is registered

	(SELECT 'HTML Help is registered' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCA