--
-- OVAL-id: OVAL7
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File kcms_configure exists

	(SELECT 'File kcms_configure exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_configure')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File kcms_configure executable and SUID or SGID
	(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_configure executable and SUID or SGID

		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_configure' AND
			OEXEC = '1')

	AND EXISTS
		-- File kcms_configure executable and SUID or SGID
		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

		EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SUID = '1')

		OR EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SGID = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL9
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0391' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- rpc.cmsd or dmispd exist
	(SELECT 'rpc.cmsd or dmispd exist' FROM Placeholder WHERE

	EXISTS
		-- File rpc.cmsd exists

		(SELECT 'File rpc.cmsd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.cmsd')

	OR EXISTS
		-- File dmispd exists

		(SELECT 'File dmispd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/dmi/dmispd'))

AND NOT EXISTS

	-- Patches 108827-30 and 108901-06
	(SELECT 'Patches 108827-30 and 108901-06' FROM Placeholder WHERE

	EXISTS
		-- Patch 108827-30 or later installed

		(SELECT 'Patch 108827-30 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '108827' AND
			PatchVersion >= '30')

	AND EXISTS
		-- Patch 108901-06 or later installed

		(SELECT 'Patch 108901-06 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '108901' AND
			PatchVersion >= '6'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.cmsd enabled OR dmispd running
	(SELECT 'rpc.cmsd enabled OR dmispd running' FROM Placeholder WHERE

	EXISTS
		-- rpc.cmsd enabled
		(SELECT 'rpc.cmsd enabled' FROM Placeholder WHERE

		EXISTS
			-- inetd.conf contains rpc.cmsd

			(SELECT 'inetd.conf contains rpc.cmsd' FROM Solaris_InetdConf WHERE
				ServerProgram = '/usr/dt/bin/rpc.cmsd')

		AND EXISTS
			-- inetd running

			(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
				Command LIKE '%inetd%' AND
				UserID = 'root')

		AND EXISTS
			-- File rpc.cmsd executable
			(SELECT 'File rpc.cmsd executable' FROM Placeholder WHERE

			EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					UEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					GEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					OEXEC = '1')))

	OR EXISTS
		-- dmispd running

		(SELECT 'dmispd running' FROM Solaris_PSInfo WHERE
			Command LIKE '%dmispd%'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL10
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0652' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File xlock exists

	(SELECT 'File xlock exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xlock')

AND NOT EXISTS

	-- Patch 108652-38 or later installed

	(SELECT 'Patch 108652-38 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '38')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File xlock SUID and executable
	(SELECT 'File xlock SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			SUID = '1')

	AND EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL11
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0796' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File snmpdx exists

	(SELECT 'File snmpdx exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/snmpdx')

AND NOT EXISTS

	-- Patch 108869-16 or later installed

	(SELECT 'Patch 108869-16 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108869' AND
		PatchVersion >= '16')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- snmpdx running

	(SELECT 'snmpdx running' FROM Solaris_PSInfo WHERE
		Command LIKE '%snmpdx%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL14
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0158' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File Xsun exists

	(SELECT 'File Xsun exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/Xsun')

AND NOT EXISTS

	-- Patch 108652-52 or later installed

	(SELECT 'Patch 108652-52 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '52')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Xsun SGID and executable
	(SELECT 'File Xsun SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			SGID = '1')

	AND EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL15
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0677' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 110286-09 or later installed

	(SELECT 'Patch 110286-09 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110286' AND
		PatchVersion >= '9')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL31
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0033' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

AND NOT EXISTS

	-- Patch 110896-02 or later installed

	(SELECT 'Patch 110896-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110896' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL33
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0158' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File Xsun exists

	(SELECT 'File Xsun exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/Xsun')

AND NOT EXISTS

	-- Patch 108376-38 or later installed

	(SELECT 'Patch 108376-38 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108376' AND
		PatchVersion >= '38')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Xsun SGID and executable
	(SELECT 'File Xsun SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			SGID = '1')

	AND EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL34
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-1076' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File whodo exists

	(SELECT 'File whodo exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '/usr/sbin/sparcv_/whodo')

AND NOT EXISTS

	-- Patch 111600-01 or later installed

	(SELECT 'Patch 111600-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111600' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File whodo SUID and executable
	(SELECT 'File whodo SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			SUID = '1')

	AND EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL41
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0573' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.rwalld exists

	(SELECT 'File rpc.rwalld exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND NOT EXISTS

	-- Patch 112899-01 or later installed

	(SELECT 'Patch 112899-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112899' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.rwalld

	(SELECT 'inetd.conf contains rpc.rwalld' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.rwalld executable
	(SELECT 'File rpc.rwalld executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL42
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0391' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- rpc.cmsd or dmispd exist
	(SELECT 'rpc.cmsd or dmispd exist' FROM Placeholder WHERE

	EXISTS
		-- File rpc.cmsd exists

		(SELECT 'File rpc.cmsd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.cmsd')

	OR EXISTS
		-- File dmispd exists

		(SELECT 'File dmispd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/dmi/dmispd'))

AND NOT EXISTS

	-- Patches 106942-22 and 108451-06
	(SELECT 'Patches 106942-22 and 108451-06' FROM Placeholder WHERE

	EXISTS
		-- Patch 106942-22 or later installed

		(SELECT 'Patch 106942-22 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '106942' AND
			PatchVersion >= '22')

	AND EXISTS
		-- Patch 108541-06 or later installed

		(SELECT 'Patch 108541-06 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '108541' AND
			PatchVersion >= '6'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.cmsd enabled OR dmispd running
	(SELECT 'rpc.cmsd enabled OR dmispd running' FROM Placeholder WHERE

	EXISTS
		-- rpc.cmsd enabled
		(SELECT 'rpc.cmsd enabled' FROM Placeholder WHERE

		EXISTS
			-- inetd.conf contains rpc.cmsd

			(SELECT 'inetd.conf contains rpc.cmsd' FROM Solaris_InetdConf WHERE
				ServerProgram = '/usr/dt/bin/rpc.cmsd')

		AND EXISTS
			-- inetd running

			(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
				Command LIKE '%inetd%' AND
				UserID = 'root')

		AND EXISTS
			-- File rpc.cmsd executable
			(SELECT 'File rpc.cmsd executable' FROM Placeholder WHERE

			EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					UEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					GEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					OEXEC = '1')))

	OR EXISTS
		-- dmispd running

		(SELECT 'dmispd running' FROM Solaris_PSInfo WHERE
			Command LIKE '%dmispd%'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL43
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL47
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-1076' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File whodo exists

	(SELECT 'File whodo exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '/usr/sbin/sparcv_/whodo')

AND NOT EXISTS

	-- Patch 111826-01 or later installed

	(SELECT 'Patch 111826-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111826' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File whodo SUID and executable
	(SELECT 'File whodo SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			SUID = '1')

	AND EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL48
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0088' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL56
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0779' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.yppasswdd exists

	(SELECT 'File rpc.yppasswdd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rpc.yppasswdd')

AND NOT EXISTS

	-- Patch 111596-02 or later installed

	(SELECT 'Patch 111596-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111596' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.yppasswdd running

	(SELECT 'rpc.yppasswdd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%rpc.yppasswdd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL60
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0088' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL62
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0797' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File mibiisa exists

	(SELECT 'File mibiisa exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/mibiisa')

AND NOT EXISTS

	-- Patch 107709-19 or later installed

	(SELECT 'Patch 107709-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107709' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mibiisa running

	(SELECT 'mibiisa running' FROM Solaris_PSInfo WHERE
		Command LIKE '%mibiisa%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL65
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File kcms_configure exists

	(SELECT 'File kcms_configure exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_configure')

AND NOT EXISTS

	-- Patch 107337-02 or later installed

	(SELECT 'Patch 107337-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107337' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File kcms_configure executable and SUID or SGID
	(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_configure executable and SUID or SGID

		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_configure' AND
			OEXEC = '1')

	AND EXISTS
		-- File kcms_configure executable and SUID or SGID
		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

		EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SUID = '1')

		OR EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SGID = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL67
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0089' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

AND NOT EXISTS

	-- Patch 110453-01 or later installed

	(SELECT 'Patch 110453-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110453' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL68
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0089' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

AND NOT EXISTS

	-- Patch 108721-02 or later installed

	(SELECT 'Patch 108721-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108721' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL70
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0803' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File dtspcd exists

	(SELECT 'File dtspcd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/dtspcd')

AND NOT EXISTS

	-- Patch 108949-07 or later installed

	(SELECT 'Patch 108949-07 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108949' AND
		PatchVersion >= '7')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains dtspcd

	(SELECT 'inetd.conf contains dtspcd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/dtspcd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File dtspcd executable
	(SELECT 'File dtspcd executable' FROM Placeholder WHERE

	EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			UEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			GEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL74
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0803' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File dtspcd exists

	(SELECT 'File dtspcd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/dtspcd')

AND NOT EXISTS

	-- Patch 106934-04 or later installed

	(SELECT 'Patch 106934-04 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '106934' AND
		PatchVersion >= '4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains dtspcd

	(SELECT 'inetd.conf contains dtspcd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/dtspcd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File dtspcd executable
	(SELECT 'File dtspcd executable' FROM Placeholder WHERE

	EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			UEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			GEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL79
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0573' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.rwalld exists

	(SELECT 'File rpc.rwalld exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND NOT EXISTS

	-- Patch 112846-01 or later installed

	(SELECT 'Patch 112846-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112846' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.rwalld

	(SELECT 'inetd.conf contains rpc.rwalld' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.rwalld executable
	(SELECT 'File rpc.rwalld executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL80
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0678' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 107893-19 or later installed

	(SELECT 'Patch 107893-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107893' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL86
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0090' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File lbxproxy exists

	(SELECT 'File lbxproxy exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/lbxproxy')

AND NOT EXISTS

	-- Patch 108652-51 or later installed

	(SELECT 'Patch 108652-51 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '51')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File lbxproxy SGID and executable
	(SELECT 'File lbxproxy SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			SGID = '1')

	AND EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL91
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0677' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 107893-19 or later installed

	(SELECT 'Patch 107893-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107893' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL94
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0797' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File mibiisa exists

	(SELECT 'File mibiisa exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/mibiisa')

AND NOT EXISTS

	-- Patch 108869-16 or later installed

	(SELECT 'Patch 108869-16 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108869' AND
		PatchVersion >= '16')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mibiisa running

	(SELECT 'mibiisa running' FROM Solaris_PSInfo WHERE
		Command LIKE '%mibiisa%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL97
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL102
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0779' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.yppasswdd exists

	(SELECT 'File rpc.yppasswdd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rpc.yppasswdd')

AND NOT EXISTS

	-- Patch 111590-02 or later installed

	(SELECT 'Patch 111590-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111590' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.yppasswdd running

	(SELECT 'rpc.yppasswdd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%rpc.yppasswdd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL114
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0796' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File snmpdx exists

	(SELECT 'File snmpdx exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/snmpdx')

AND NOT EXISTS

	-- Patch 107709-19 or later installed

	(SELECT 'Patch 107709-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107709' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- snmpdx running

	(SELECT 'snmpdx running' FROM Solaris_PSInfo WHERE
		Command LIKE '%snmpdx%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL120
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File kcms_server exists

	(SELECT 'File kcms_server exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_server')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains kcms_server

	(SELECT 'inetd.conf contains kcms_server' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/bin/kcms_server')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File kcms_server executable and SUID or SGID
	(SELECT 'File kcms_server executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			UEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			GEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL124
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0033' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL131
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0652' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File xlock exists

	(SELECT 'File xlock exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xlock')

AND NOT EXISTS

	-- Patch 108376-30 or later installed

	(SELECT 'Patch 108376-30 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108376' AND
		PatchVersion >= '30')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File xlock SUID and executable
	(SELECT 'File xlock SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			SUID = '1')

	AND EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL149
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1317' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File fs.auto exists

	(SELECT 'File fs.auto exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- File xfs exists

	(SELECT 'File xfs exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xfs')

AND NOT EXISTS

	-- Patch 109862-03 or later installed

	(SELECT 'Patch 109862-03 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '109862' AND
		PatchVersion >= '3')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains fs.auto

	(SELECT 'inetd.conf contains fs.auto' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File xfs executable
	(SELECT 'File xfs executable' FROM Placeholder WHERE

	EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			UEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			GEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL152
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1317' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File fs.auto exists

	(SELECT 'File fs.auto exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- File xfs exists

	(SELECT 'File xfs exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xfs')

AND NOT EXISTS

	-- Patch 108117-06 or later installed

	(SELECT 'Patch 108117-06 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108117' AND
		PatchVersion >= '6')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains fs.auto

	(SELECT 'inetd.conf contains fs.auto' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File xfs executable
	(SELECT 'File xfs executable' FROM Placeholder WHERE

	EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			UEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			GEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL175
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0678' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 110286-09 or later installed

	(SELECT 'Patch 110286-09 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110286' AND
		PatchVersion >= '9')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL177
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0679' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 107893-20 or later installed

	(SELECT 'Patch 107893-20 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107893' AND
		PatchVersion >= '20')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL179
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0090' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File lbxproxy exists

	(SELECT 'File lbxproxy exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/lbxproxy')

AND NOT EXISTS

	-- Patch 107654-10 or later installed

	(SELECT 'Patch 107654-10 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107654' AND
		PatchVersion >= '10')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File lbxproxy SGID and executable
	(SELECT 'File lbxproxy SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			SGID = '1')

	AND EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL192
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0679' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 110286-10 or later installed

	(SELECT 'Patch 110286-10 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110286' AND
		PatchVersion >= '10')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL195
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File kcms_server exists

	(SELECT 'File kcms_server exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_server')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains kcms_server

	(SELECT 'inetd.conf contains kcms_server' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/bin/kcms_server')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File kcms_server executable and SUID or SGID
	(SELECT 'File kcms_server executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			UEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			GEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1099
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0677' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 9 Installed

	(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.9')

AND EXISTS

	-- Toolktalk installed

	(SELECT 'Toolktalk installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWtltk')

AND NOT EXISTS

	-- Patch 112808-02 or later installed

	(SELECT 'Patch 112808-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112808' AND
		PatchVersion >= '02')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1273
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0722' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND EXISTS

	-- System and Network Administration Framework Installed

	(SELECT 'System and Network Administration Framework Installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWadmfw')

AND NOT EXISTS

	-- Patch 116457-02 or later installed

	(SELECT 'Patch 116457-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116457' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 116442-01 or later installed

	(SELECT 'Patch 116442-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116442' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 116454-01 or later installed

	(SELECT 'Patch 116454-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116454' AND
		PatchVersion >= '01')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- inetd.conf contains sadmind

	(SELECT 'inetd.conf contains sadmind' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/sbin/sadmind')

AND NOT EXISTS

	-- Sadmin called using strong authentication

	(SELECT 'Sadmin called using strong authentication' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/sbin/sadmind' AND
		ServerArguments = '-S 2')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1436
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0368' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- File /usr/dt/bin/dtlogin exists

	(SELECT 'File /usr/dt/bin/dtlogin exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/dtlogin')

AND EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND EXISTS

	-- Patch 108919-21 or later installed

	(SELECT 'Patch 108919-21 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108919' AND
		PatchVersion >= '21')

AND EXISTS

	-- Patch 112807-09 or later installed

	(SELECT 'Patch 112807-09 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112807' AND
		PatchVersion >= '09')

AND EXISTS

	-- Patch 107180-31 or later installed

	(SELECT 'Patch 107180-31 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107180' AND
		PatchVersion >= '31')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- dtlogin running

	(SELECT 'dtlogin running' FROM Solaris_PSInfo WHERE
		Command LIKE '%dtlogin%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1982
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0174' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 116973-01 or later installed

	(SELECT 'Patch 116973-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116973' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 113146-05 or later installed

	(SELECT 'Patch 113146-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113146' AND
		PatchVersion >= '05')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL2011
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0914' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 106938-08 or later installed

	(SELECT 'Patch 106938-08 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '106938' AND
		PatchVersion >= '08')

AND NOT EXISTS

	-- Patch 109326-13 or later installed

	(SELECT 'Patch 109326-13 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '109326' AND
		PatchVersion >= '13')

AND NOT EXISTS

	-- Patch 112970-06 or later installed

	(SELECT 'Patch 112970-06 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112970' AND
		PatchVersion >= '06')

AND EXISTS

	-- Core Solaris (SUNWcsu) installed

	(SELECT 'Core Solaris (SUNWcsu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWcsu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- in.named running

	(SELECT 'in.named running' FROM Solaris_PSInfo WHERE
		Command = '/usr/sbin/in.named')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL2590
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0545' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 113505-02 or later installed

	(SELECT 'Patch 113505-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113505' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 113508-02 or later installed

	(SELECT 'Patch 113508-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113508' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 115054-01 or later installed

	(SELECT 'Patch 115054-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115054' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 115055-01 or later installed

	(SELECT 'Patch 115055-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115055' AND
		PatchVersion >= '01')

AND EXISTS

	-- SunCluster Component SUNWscvw installed

	(SELECT 'SunCluster Component SUNWscvw installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWscvw')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running with SunPlex Manager config

	(SELECT 'Apache running with SunPlex Manager config' FROM Solaris_PSInfo WHERE
		Command LIKE '/usr/apache/bin/httpd%SUNWscvw/conf/httpd_conf%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL2621
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0079' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 114796-04 or later installed

	(SELECT 'Patch 114796-04 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '114796' AND
		PatchVersion >= '04')

AND EXISTS

	-- Sun Crypto Accelerator 4000 software installed

	(SELECT 'Sun Crypto Accelerator 4000 software installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWkcl2r')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL2770
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0678' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 9 Installed

	(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.9')

AND EXISTS

	-- Toolktalk installed

	(SELECT 'Toolktalk installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWtltk')

AND NOT EXISTS

	-- Patch 112808-02 or later installed

	(SELECT 'Patch 112808-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112808' AND
		PatchVersion >= '02')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL3799
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0542' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 113146-03 or later installed

	(SELECT 'Patch 113146-03 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113146' AND
		PatchVersion >= '03')

AND NOT EXISTS

	-- Patch 116973-01 or later installed

	(SELECT 'Patch 116973-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116973' AND
		PatchVersion >= '01')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4030
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0800' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 109613-07 or later installed

	(SELECT 'Patch 109613-07 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '109613' AND
		PatchVersion >= '07')

AND NOT EXISTS

	-- Patch 112810-06 or later installed

	(SELECT 'Patch 112810-06 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112810' AND
		PatchVersion >= '06')

AND EXISTS

	-- CDE Desktop Applications (SUNWdtdst) installed                                                                                               

	(SELECT 'CDE Desktop Applications (SUNWdtdst) installed                                                                                               ' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWdtdst')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4114
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0020' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 116973-01 or later installed

	(SELECT 'Patch 116973-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116973' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 113146-05 or later installed

	(SELECT 'Patch 113146-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113146' AND
		PatchVersion >= '05')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4254
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0543' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 113505-02 or later installed

	(SELECT 'Patch 113505-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113505' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 113508-02 or later installed

	(SELECT 'Patch 113508-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113508' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 115054-01 or later installed

	(SELECT 'Patch 115054-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115054' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 115055-01 or later installed

	(SELECT 'Patch 115055-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115055' AND
		PatchVersion >= '01')

AND EXISTS

	-- SunCluster Component SUNWscvw installed

	(SELECT 'SunCluster Component SUNWscvw installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWscvw')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running with SunPlex Manager config

	(SELECT 'Apache running with SunPlex Manager config' FROM Solaris_PSInfo WHERE
		Command LIKE '/usr/apache/bin/httpd%SUNWscvw/conf/httpd_conf%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4416
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0987' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 116973-01 or later installed

	(SELECT 'Patch 116973-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116973' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 113146-05 or later installed

	(SELECT 'Patch 113146-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113146' AND
		PatchVersion >= '05')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4574
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0544' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 113505-02 or later installed

	(SELECT 'Patch 113505-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113505' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 113508-02 or later installed

	(SELECT 'Patch 113508-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113508' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 115054-01 or later installed

	(SELECT 'Patch 115054-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115054' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 115055-01 or later installed

	(SELECT 'Patch 115055-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115055' AND
		PatchVersion >= '01')

AND EXISTS

	-- SunCluster Component SUNWscvw installed

	(SELECT 'SunCluster Component SUNWscvw installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWscvw')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running with SunPlex Manager config

	(SELECT 'Apache running with SunPlex Manager config' FROM Solaris_PSInfo WHERE
		Command LIKE '/usr/apache/bin/httpd%SUNWscvw/conf/httpd_conf%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4661
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0772' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 9 Installed

	(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.9')

AND EXISTS

	-- Kerberos 5 installed

	(SELECT 'Kerberos 5 installed' FROM Solaris_FileAttributes WHERE
		FilePath = '/etc/krb5/krb5.conf')

AND NOT EXISTS

	-- Patch 112908-15 or later installed

	(SELECT 'Patch 112908-15 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112908' AND
		PatchVersion >= '15')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Kerberos Key Distribution Center (krb5kdc) running

	(SELECT 'Kerberos Key Distribution Center (krb5kdc) running' FROM Solaris_PSInfo WHERE
		Command LIKE '%krb5kdc%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4670
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0993' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 116973-01 or later installed

	(SELECT 'Patch 116973-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116973' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 113146-05 or later installed

	(SELECT 'Patch 113146-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113146' AND
		PatchVersion >= '05')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL4863
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0492' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 116973-01 or later installed

	(SELECT 'Patch 116973-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116973' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 113146-05 or later installed

	(SELECT 'Patch 113146-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113146' AND
		PatchVersion >= '05')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

