--
-- OVAL-id: OVAL994
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0416' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- cvs rpm version prior to 1.11.2-24 is installed

	(SELECT 'cvs rpm version prior to 1.11.2-24 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '24' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

