--
-- OVAL-id: OVAL978
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0235' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- lha version is less than 1.14i-10.2

	(SELECT 'lha version is less than 1.14i-10.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'lha' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.14i' AND
		RPMTestedRelease = '10.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/lha is executable
	(SELECT '/usr/bin/lha is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

