--
-- OVAL-id: OVAL976
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0184' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '%3_S%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.E3.2

	(SELECT 'tcpdump version is less than 3.7.2-7.E3.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.E3.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

