--
-- OVAL-id: OVAL971
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0421' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- libpng/libpng-devel is less than 1.2.2-21 or libpng10/libpng-devel less than 1.0.13 is installed
	(SELECT 'libpng/libpng-devel is less than 1.2.2-21 or libpng10/libpng-devel less than 1.0.13 is installed' FROM Placeholder WHERE

	EXISTS
		-- libpng version is less than 1.2.2-21

		(SELECT 'libpng version is less than 1.2.2-21' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '21' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng-devel version is less than 1.2.2-21

		(SELECT 'libpng-devel version is less than 1.2.2-21' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng-devel' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '21' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10 version is less than 1.0.13-12

		(SELECT 'libpng10 version is less than 1.0.13-12' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '12' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10-devel version is less than 1.0.13-12

		(SELECT 'libpng10-devel version is less than 1.0.13-12' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '12' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

