--
-- OVAL-id: OVAL969
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0807' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 Server or Terminal Server is installed
	(SELECT 'Windows NT 4.0 Server or Terminal Server is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	OR EXISTS
		-- Server or Terminal Server product option
		(SELECT 'Server or Terminal Server product option' FROM Placeholder WHERE

		EXISTS
			-- Windows server product option
			(SELECT 'Windows server product option' FROM Placeholder WHERE

			EXISTS
				-- this is an NT Server (stand-alone)

				(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%ServerNT%')

			OR EXISTS
				-- this is an NT Server (domain controller)

				(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%LanmanNT%'))

		OR EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')))

AND EXISTS

	-- a vulnerable version of rpcproxy.dll exists on NT
	(SELECT 'a vulnerable version of rpcproxy.dll exists on NT' FROM Placeholder WHERE

	EXISTS
		-- non Terminal Server and rpcproxy.dll is less than 4.0.1381.7255
		(SELECT 'non Terminal Server and rpcproxy.dll is less than 4.0.1381.7255' FROM Placeholder WHERE

		NOT EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of rpcproxy.dll is less than 4.0.1381.7255

			(SELECT 'the version of rpcproxy.dll is less than 4.0.1381.7255' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\rpcproxy.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7255)))))))

	OR EXISTS
		-- Terminal Server and rpcproxy.dll is less than 4.0.1381.33559
		(SELECT 'Terminal Server and rpcproxy.dll is less than 4.0.1381.33559' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of rpcproxy.dll is less than 4.0.1381.33559

			(SELECT 'the version of rpcproxy.dll is less than 4.0.1381.33559' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\rpcproxy.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33559))))))))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- COM Internet Services are enabled

	(SELECT 'COM Internet Services are enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
		EntryName = 'EnableDCOMHTTP' AND
		EntryValue = 'Y')

--
-- ### END VULNERABLE CONFIGURATION
;

