--
-- OVAL-id: OVAL968
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0197' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of Microsoft Jet 4.0 is installed
	(SELECT 'a vulnerable version of Microsoft Jet 4.0 is installed' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and msjet40.dll is less than 4.0.8618.0
		(SELECT '32-bit version of Windows and msjet40.dll is less than 4.0.8618.0' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- the version of msjet40.dll is less than 4.0.8618.0

			(SELECT 'the version of msjet40.dll is less than 4.0.8618.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msjet40.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 8618 OR Version3 = 8618 AND
				Version4 < 0)))))))

	OR EXISTS
		-- 64-bit version of Windows and wmsjet40.dll is less than 4.0.8618.0
		(SELECT '64-bit version of Windows and wmsjet40.dll is less than 4.0.8618.0' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of wmsjet40.dll is less than 4.0.8618.0

			(SELECT 'the version of wmsjet40.dll is less than 4.0.8618.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\wmsjet40.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 8618 OR Version3 = 8618 AND
				Version4 < 0))))))))

AND NOT EXISTS

	-- the patch kb837001 is installed

	(SELECT 'the patch kb837001 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB837001' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

