--
-- OVAL-id: OVAL964
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0117' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND EXISTS

	-- a vulnerable version of h323.tsp exists
	(SELECT 'a vulnerable version of h323.tsp exists' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of h323.tsp exists
		(SELECT '32-bit version of Windows and a vulnerable version of h323.tsp exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of h323.tsp exists depending on service pack level
			(SELECT 'a vulnerable version of h323.tsp exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- no service pack is installed and h323.tsp is less than 5.1.2600.134
				(SELECT 'no service pack is installed and h323.tsp is less than 5.1.2600.134' FROM Placeholder WHERE

				NOT EXISTS
					-- a Win2K/XP/2003 service pack is installed

					(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion')

				AND EXISTS
					-- the version of h323.tsp is less than 5.1.2600.134

					(SELECT 'the version of h323.tsp is less than 5.1.2600.134' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\h323.tsp' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 134)))))))

			OR EXISTS
				-- service pack 1 is installed and h323.tsp is less than 5.1.2600.1348
				(SELECT 'service pack 1 is installed and h323.tsp is less than 5.1.2600.1348' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 1 is installed

					(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 1')

				AND EXISTS
					-- the version of h323.tsp is less than 5.1.2600.1348

					(SELECT 'the version of h323.tsp is less than 5.1.2600.1348' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\h323.tsp' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1348)))))))))

	OR EXISTS
		-- 64-bit version of Windows and h323.tsp is less than 5.1.2600.1348
		(SELECT '64-bit version of Windows and h323.tsp is less than 5.1.2600.1348' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of h323.tsp is less than 5.1.2600.1348

			(SELECT 'the version of h323.tsp is less than 5.1.2600.1348' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\h323.tsp' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1348))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

