--
-- OVAL-id: OVAL962
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0353' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- DataAccess Installed

	(SELECT 'DataAccess Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.6%')

AND EXISTS

	-- File %windir%\System32\odbcbcp.dll is less than 2000.80.746.0

	(SELECT 'File %windir%\System32\odbcbcp.dll is less than 2000.80.746.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 746 OR Version3 = 746 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- Patch Q823718 Installed

	(SELECT 'Patch Q823718 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q823718' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

