--
-- OVAL-id: OVAL940
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0109' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel versions
	(SELECT 'kernel versions' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel-smp version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-hugemem version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel-hugemem version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-hugemem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /bin/mount is world-executable AND Set-UID
	(SELECT '/bin/mount is world-executable AND Set-UID' FROM Placeholder WHERE

	EXISTS
		-- /bin/mount is world-executable AND Set-UID

		(SELECT '/bin/mount is world-executable AND Set-UID' FROM RedHat_FileAttributes WHERE
			FilePath = '/bin/mount' AND
			OEXEC = '1')

	AND EXISTS
		-- /bin/mount is world-executable AND Set-UID

		(SELECT '/bin/mount is world-executable AND Set-UID' FROM RedHat_FileAttributes WHERE
			FilePath = '/bin/mount' AND
			SUID = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

