--
-- OVAL-id: OVAL915
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-1999-0874' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS 4.0 Major Version

	(SELECT 'IIS 4.0 Major Version' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '4')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\w3svc.dll is less than 4.0.1381.164

	(SELECT 'File %windir%\System32\w3svc.dll is less than 4.0.1381.164' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\w3svc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 164))))))

AND NOT EXISTS

	-- Service Pack 6 Installed (or later)

	(SELECT 'Service Pack 6 Installed (or later)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 6')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

