--
-- OVAL-id: OVAL900
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0813' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND EXISTS

	-- a vulnerable version of rpcrt4.dll exists on XP
	(SELECT 'a vulnerable version of rpcrt4.dll exists on XP' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of rpcrt4.dll exists
		(SELECT '32-bit version of Windows and a vulnerable version of rpcrt4.dll exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of rpcrt4.dll exists depending on service pack level
			(SELECT 'a vulnerable version of rpcrt4.dll exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- no service pack is installed and rpcrt4.dll is less than 5.1.2600.135
				(SELECT 'no service pack is installed and rpcrt4.dll is less than 5.1.2600.135' FROM Placeholder WHERE

				NOT EXISTS
					-- a Win2K/XP/2003 service pack is installed

					(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion')

				AND EXISTS
					-- the version of rpcrt4.dll is less than 5.1.2600.135

					(SELECT 'the version of rpcrt4.dll is less than 5.1.2600.135' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 135)))))))

			OR EXISTS
				-- service pack 1 is installed and rpcrt4.dll is less than 5.1.2600.1361
				(SELECT 'service pack 1 is installed and rpcrt4.dll is less than 5.1.2600.1361' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 1 is installed

					(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 1')

				AND EXISTS
					-- the version of rpcrt4.dll is less than 5.1.2600.1361

					(SELECT 'the version of rpcrt4.dll is less than 5.1.2600.1361' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1361)))))))))

	OR EXISTS
		-- 64-bit version of Windows and rpcrt4.dll is less than 5.1.2600.1361
		(SELECT '64-bit version of Windows and rpcrt4.dll is less than 5.1.2600.1361' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of rpcrt4.dll is less than 5.1.2600.1361

			(SELECT 'the version of rpcrt4.dll is less than 5.1.2600.1361' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1361))))))))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

