--
-- OVAL-id: OVAL897
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0906' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of mf3216.dll exists on NT
	(SELECT 'a vulnerable version of mf3216.dll exists on NT' FROM Placeholder WHERE

	EXISTS
		-- non Terminal Server and mf3216.dll is less than 4.0.1381.7263
		(SELECT 'non Terminal Server and mf3216.dll is less than 4.0.1381.7263' FROM Placeholder WHERE

		NOT EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of mf3216.dll is less than 4.0.1381.7263

			(SELECT 'the version of mf3216.dll is less than 4.0.1381.7263' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\mf3216.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7263)))))))

	OR EXISTS
		-- NT Terminal Server and mf3216.dll is less than 4.0.1381.33562
		(SELECT 'NT Terminal Server and mf3216.dll is less than 4.0.1381.33562' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of mf3216.dll is less than 4.0.1381.33562

			(SELECT 'the version of mf3216.dll is less than 4.0.1381.33562' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\mf3216.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33562))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

