--
-- OVAL-id: OVAL894
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0813' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- a vulnerable version of rpcrt4.dll exists on Server 2003
	(SELECT 'a vulnerable version of rpcrt4.dll exists on Server 2003' FROM Placeholder WHERE

	EXISTS
		-- machine has followed the GDR update path and rpcrt4.dll is less than 5.2.3790.137

		-- unknown_test
		-- NOTE: 

		(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

	OR EXISTS
		-- machine has followed the QFE update path and rpcrt4.dll is less than 5.2.3790.141

		-- unknown_test
		-- NOTE: 

		(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

