--
-- OVAL-id: OVAL873
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mozilla version is less than 1.4.2-0.9.0

	(SELECT 'mozilla version is less than 1.4.2-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mozilla' AND
		RPMTestedEpoch = '37' AND
		RPMTestedVersion = '1.4.2' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mozilla is executable
	(SELECT '/usr/bin/mozilla is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

