--
-- OVAL-id: OVAL867
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0985' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.21-4.0.2.EL

		(SELECT 'kernel version is less than 2.4.21-4.0.2.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '4.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.21-4.0.2.EL

		(SELECT 'kernel-smp version is less than 2.4.21-4.0.2.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '4.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.21-4.0.2.EL

		(SELECT 'kernel-bigmem version is less than 2.4.21-4.0.2.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '4.0.2.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

