--
-- OVAL-id: OVAL866
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0977' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cvs version is less than 1.11.2-14

	(SELECT 'cvs version is less than 1.11.2-14' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '14' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- / is world-writable

	(SELECT '/ is world-writable' FROM RedHat_FileAttributes WHERE
		FilePath = '/' AND
		OWRITE = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

