--
-- OVAL-id: OVAL854
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0057' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.E3.1

	(SELECT 'tcpdump version is less than 3.7.2-7.E3.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.E3.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

