--
-- OVAL-id: OVAL843
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0121' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Outlook 2002 is installed

	(SELECT 'Outlook 2002 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Office\10.0\Outlook\InstallRoot')

AND EXISTS

	-- the version of outlook.exe is less than 10.00.5709.0000

	(SELECT 'the version of outlook.exe is less than 10.00.5709.0000' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'outlook.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths' AND
			EntryName = 'OUTLOOK.EXE') AND
		(Version1 < 10 OR (Version1 = 10 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 5709 OR Version3 = 5709 AND
		Version4 < 0000))))))

AND NOT EXISTS

	-- the patch kb828040 is installed

	(SELECT 'the patch kb828040 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{90280409-6000-11D3-8CFE-0050048383C9}' AND
		EntryName = 'DisplayVersion' AND
		EntryValue = '10.0.4333.0')

AND NOT EXISTS

	-- Microsoft Office XP Service Pack 3 is installed

	(SELECT 'Microsoft Office XP Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{90280409-6000-11D3-8CFE-0050048383C9}' AND
		EntryName = 'DisplayVersion' AND
		EntryValue = '10.0.6626.0')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

