--
-- OVAL-id: OVAL842
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0905' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Media Services 4.1 is installed on Microsoft Windows 2000 Server
	(SELECT 'Windows Media Services 4.1 is installed on Microsoft Windows 2000 Server' FROM Placeholder WHERE

	EXISTS
		-- Windows Media Services 4.1 is installed

		(SELECT 'Windows Media Services 4.1 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NetShow' AND
			EntryName = 'Version' AND
			EntryValue = '4.1')

	AND EXISTS
		-- Windows 2000 Server is installed
		(SELECT 'Windows 2000 Server is installed' FROM Placeholder WHERE

		EXISTS
			-- Windows 2000 is installed

			(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CurrentVersion' AND
				EntryValue = '5.0')

		AND EXISTS
			-- Windows server product option
			(SELECT 'Windows server product option' FROM Placeholder WHERE

			EXISTS
				-- this is an NT Server (stand-alone)

				(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%ServerNT%')

			OR EXISTS
				-- this is an NT Server (domain controller)

				(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%LanmanNT%'))))

AND EXISTS

	-- the version of nscm.exe is less than 4.1.0.3934

	(SELECT 'the version of nscm.exe is less than 4.1.0.3934' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Windows Media\Server\nscm.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3934))))))

AND EXISTS

	-- the version of nspmon.exe is less than 4.1.0.3934

	(SELECT 'the version of nspmon.exe is less than 4.1.0.3934' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Windows Media\Server\nspmon.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 3934))))))

AND NOT EXISTS

	-- the patch kb832359 is installed

	(SELECT 'the patch kb832359 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Services\KB832359' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- configured to only offer streaming media over unicast

	-- unknown_test
	-- NOTE: 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND NOT EXISTS

	-- the Windows Media Station service is disabled

	(SELECT 'the Windows Media Station service is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\nsstation' AND
		EntryName = 'Start' AND
		EntryValue != '4')

AND NOT EXISTS

	-- the Windows Media Monitor service is disabled

	(SELECT 'the Windows Media Monitor service is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Services\KB832359' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

