--
-- OVAL-id: OVAL834
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0003' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.20-30.9

		(SELECT 'kernel version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.20-30.9

		(SELECT 'kernel-smp version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.20-30.9

		(SELECT 'kernel-bigmem version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

