--
-- OVAL-id: OVAL826
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0097' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- pwlib version is less than 1.4.7-7.EL

	(SELECT 'pwlib version is less than 1.4.7-7.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'pwlib' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.4.7' AND
		RPMTestedRelease = '7.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- a program is listening on TCP or UDP port 1720

	(SELECT 'a program is listening on TCP or UDP port 1720' FROM RedHat_InetListeningServers WHERE
		LocalPort = '1720' AND
		ProgramName LIKE '%')

--
-- ### END VULNERABLE CONFIGURATION
;

