--
-- OVAL-id: OVAL822
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1023' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mc version is less than 4.6.0-7.9

	(SELECT 'mc version is less than 4.6.0-7.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mc' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '4.6.0' AND
		RPMTestedRelease = '7.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mc is executable
	(SELECT '/usr/bin/mc is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mc is executable

		(SELECT '/usr/bin/mc is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mc' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mc is executable

		(SELECT '/usr/bin/mc is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mc' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mc is executable

		(SELECT '/usr/bin/mc is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mc' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

