--
-- OVAL-id: OVAL821
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0848' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- slocate version is less than 2.7-2

	(SELECT 'slocate version is less than 2.7-2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'slocate' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.7' AND
		RPMTestedRelease = '2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/slocate is setgid
	(SELECT '/usr/bin/slocate is setgid' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/slocate is setgid

		(SELECT '/usr/bin/slocate is setgid' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/slocate' AND
			SGID = '1')

	AND EXISTS
		-- /usr/bin/slocate is setgid

		(SELECT '/usr/bin/slocate is setgid' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/slocate' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

