--
-- OVAL-id: OVAL82
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-0509' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- the version of ssmsrp70.dll is less than 2000.80.213.0

	(SELECT 'the version of ssmsrp70.dll is less than 2000.80.213.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssmsrp70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 213 OR Version3 = 213 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of dbmsrpcn.dll is less than 2000.80.213.0

	(SELECT 'the version of dbmsrpcn.dll is less than 2000.80.213.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dbmsrpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 213 OR Version3 = 213 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- File sqlservr.exe version3 greater than or equal to 384

	(SELECT 'File sqlservr.exe version3 greater than or equal to 384' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 >= 2000 AND
	Version2 >= 80 AND
	Version3 >= 384 AND
	Version4 >= 0))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

