--
-- OVAL-id: OVAL815
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0992' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mailman version is less than 2.1.1-5

	(SELECT 'mailman version is less than 2.1.1-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mailman' AND
		RPMTestedEpoch = '3' AND
		RPMTestedVersion = '2.1.1' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening on the network

	(SELECT 'httpd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

