--
-- OVAL-id: OVAL804
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0924' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- netpbm version is less than 9.24-10.90.1

		(SELECT 'netpbm version is less than 9.24-10.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '10.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- netpbm-devel version is less than 9.24-10.90.1

		(SELECT 'netpbm-devel version is less than 9.24-10.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '10.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- netpbm-progs version is less than 9.24-10.90.1

		(SELECT 'netpbm-progs version is less than 9.24-10.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm-progs' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '10.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable configuration
	(SELECT 'Vulnerable configuration' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/411toppm is executable
		(SELECT '/usr/bin/411toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/asciitopgm is executable
		(SELECT '/usr/bin/asciitopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/atktopbm is executable
		(SELECT '/usr/bin/atktopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/bioradtopgm is executable
		(SELECT '/usr/bin/bioradtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/bmptoppm is executable
		(SELECT '/usr/bin/bmptoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/brushtopbm is executable
		(SELECT '/usr/bin/brushtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/cmuwmtopbm is executable
		(SELECT '/usr/bin/cmuwmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/eyuvtoppm is executable
		(SELECT '/usr/bin/eyuvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fiascotopnm is executable
		(SELECT '/usr/bin/fiascotopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fitstopnm is executable
		(SELECT '/usr/bin/fitstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fstopgm is executable
		(SELECT '/usr/bin/fstopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/g3topbm is executable
		(SELECT '/usr/bin/g3topbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gemtopbm is executable
		(SELECT '/usr/bin/gemtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gemtopnm is executable
		(SELECT '/usr/bin/gemtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/giftopnm is executable
		(SELECT '/usr/bin/giftopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gouldtoppm is executable
		(SELECT '/usr/bin/gouldtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/hipstopgm is executable
		(SELECT '/usr/bin/hipstopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/hpcdtoppm is executable
		(SELECT '/usr/bin/hpcdtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/icontopbm is executable
		(SELECT '/usr/bin/icontopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ilbmtoppm is executable
		(SELECT '/usr/bin/ilbmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/imgtoppm is executable
		(SELECT '/usr/bin/imgtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/jpegtopnm is executable
		(SELECT '/usr/bin/jpegtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/leaftoppm is executable
		(SELECT '/usr/bin/leaftoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/lispmtopgm is executable
		(SELECT '/usr/bin/lispmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/macptopbm is executable
		(SELECT '/usr/bin/macptopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mdatopbm is executable
		(SELECT '/usr/bin/mdatopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mgrtopbm is executable
		(SELECT '/usr/bin/mgrtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mtvtoppm is executable
		(SELECT '/usr/bin/mtvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/neotoppm is executable
		(SELECT '/usr/bin/neotoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/palmtopnm is executable
		(SELECT '/usr/bin/palmtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamchannel is executable
		(SELECT '/usr/bin/pamchannel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamcut is executable
		(SELECT '/usr/bin/pamcut is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamdeinterlace is executable
		(SELECT '/usr/bin/pamdeinterlace is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamfile is executable
		(SELECT '/usr/bin/pamfile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamoil is executable
		(SELECT '/usr/bin/pamoil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamstretch is executable
		(SELECT '/usr/bin/pamstretch is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamtopnm is executable
		(SELECT '/usr/bin/pamtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmclean is executable
		(SELECT '/usr/bin/pbmclean is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmlife is executable
		(SELECT '/usr/bin/pbmlife is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmmake is executable
		(SELECT '/usr/bin/pbmmake is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmmask is executable
		(SELECT '/usr/bin/pbmmask is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmpage is executable
		(SELECT '/usr/bin/pbmpage is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmpscale is executable
		(SELECT '/usr/bin/pbmpscale is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmreduce is executable
		(SELECT '/usr/bin/pbmreduce is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtext is executable
		(SELECT '/usr/bin/pbmtext is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmto10x is executable
		(SELECT '/usr/bin/pbmto10x is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmto4425 is executable
		(SELECT '/usr/bin/pbmto4425 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoascii is executable
		(SELECT '/usr/bin/pbmtoascii is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoatk is executable
		(SELECT '/usr/bin/pbmtoatk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtobbnbg is executable
		(SELECT '/usr/bin/pbmtobbnbg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtocmuwm is executable
		(SELECT '/usr/bin/pbmtocmuwm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoepsi is executable
		(SELECT '/usr/bin/pbmtoepsi is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoepson is executable
		(SELECT '/usr/bin/pbmtoepson is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtog3 is executable
		(SELECT '/usr/bin/pbmtog3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtogem is executable
		(SELECT '/usr/bin/pbmtogem is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				OEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				UEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtogo is executable
		(SELECT '/usr/bin/pbmtogo is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoicon is executable
		(SELECT '/usr/bin/pbmtoicon is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtolj is executable
		(SELECT '/usr/bin/pbmtolj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoln03 is executable
		(SELECT '/usr/bin/pbmtoln03 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtolps is executable
		(SELECT '/usr/bin/pbmtolps is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomacp is executable
		(SELECT '/usr/bin/pbmtomacp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomda is executable
		(SELECT '/usr/bin/pbmtomda is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomgr is executable
		(SELECT '/usr/bin/pbmtomgr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtonokia is executable
		(SELECT '/usr/bin/pbmtonokia is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopgm is executable
		(SELECT '/usr/bin/pbmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopi3 is executable
		(SELECT '/usr/bin/pbmtopi3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopk is executable
		(SELECT '/usr/bin/pbmtopk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoplot is executable
		(SELECT '/usr/bin/pbmtoplot is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoppa is executable
		(SELECT '/usr/bin/pbmtoppa is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopsg3 is executable
		(SELECT '/usr/bin/pbmtopsg3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoptx is executable
		(SELECT '/usr/bin/pbmtoptx is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtowbmp is executable
		(SELECT '/usr/bin/pbmtowbmp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtox10bm is executable
		(SELECT '/usr/bin/pbmtox10bm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoxbm is executable
		(SELECT '/usr/bin/pbmtoxbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoybm is executable
		(SELECT '/usr/bin/pbmtoybm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtozinc is executable
		(SELECT '/usr/bin/pbmtozinc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmupc is executable
		(SELECT '/usr/bin/pbmupc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pcxtoppm is executable
		(SELECT '/usr/bin/pcxtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmbentley is executable
		(SELECT '/usr/bin/pgmbentley is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmcrater is executable
		(SELECT '/usr/bin/pgmcrater is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmedge is executable
		(SELECT '/usr/bin/pgmedge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmenhance is executable
		(SELECT '/usr/bin/pgmenhance is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmhist is executable
		(SELECT '/usr/bin/pgmhist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmkernel is executable
		(SELECT '/usr/bin/pgmkernel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmnoise is executable
		(SELECT '/usr/bin/pgmnoise is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmnorm is executable
		(SELECT '/usr/bin/pgmnorm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmoil is executable
		(SELECT '/usr/bin/pgmoil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmramp is executable
		(SELECT '/usr/bin/pgmramp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmslice is executable
		(SELECT '/usr/bin/pgmslice is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtexture is executable
		(SELECT '/usr/bin/pgmtexture is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtofs is executable
		(SELECT '/usr/bin/pgmtofs is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtolispm is executable
		(SELECT '/usr/bin/pgmtolispm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtopbm is executable
		(SELECT '/usr/bin/pgmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtoppm is executable
		(SELECT '/usr/bin/pgmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pi1toppm is executable
		(SELECT '/usr/bin/pi1toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pi3topbm is executable
		(SELECT '/usr/bin/pi3topbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pjtoppm is executable
		(SELECT '/usr/bin/pjtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pktopbm is executable
		(SELECT '/usr/bin/pktopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pngtopnm is executable
		(SELECT '/usr/bin/pngtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmalias is executable
		(SELECT '/usr/bin/pnmalias is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmarith is executable
		(SELECT '/usr/bin/pnmarith is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcat is executable
		(SELECT '/usr/bin/pnmcat is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcolormap is executable
		(SELECT '/usr/bin/pnmcolormap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcomp is executable
		(SELECT '/usr/bin/pnmcomp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmconvol is executable
		(SELECT '/usr/bin/pnmconvol is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcrop is executable
		(SELECT '/usr/bin/pnmcrop is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcut is executable
		(SELECT '/usr/bin/pnmcut is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmdepth is executable
		(SELECT '/usr/bin/pnmdepth is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmenlarge is executable
		(SELECT '/usr/bin/pnmenlarge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmfile is executable
		(SELECT '/usr/bin/pnmfile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmflip is executable
		(SELECT '/usr/bin/pnmflip is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmgamma is executable
		(SELECT '/usr/bin/pnmgamma is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmhisteq is executable
		(SELECT '/usr/bin/pnmhisteq is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmhistmap is executable
		(SELECT '/usr/bin/pnmhistmap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnminterp is executable
		(SELECT '/usr/bin/pnminterp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnminvert is executable
		(SELECT '/usr/bin/pnminvert is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmmontage is executable
		(SELECT '/usr/bin/pnmmontage is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmnlfilt is executable
		(SELECT '/usr/bin/pnmnlfilt is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmnoraw is executable
		(SELECT '/usr/bin/pnmnoraw is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpad is executable
		(SELECT '/usr/bin/pnmpad is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpaste is executable
		(SELECT '/usr/bin/pnmpaste is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpsnr is executable
		(SELECT '/usr/bin/pnmpsnr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmremap is executable
		(SELECT '/usr/bin/pnmremap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmrotate is executable
		(SELECT '/usr/bin/pnmrotate is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmscale is executable
		(SELECT '/usr/bin/pnmscale is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmscalefixed is executable
		(SELECT '/usr/bin/pnmscalefixed is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmshear is executable
		(SELECT '/usr/bin/pnmshear is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmsmooth is executable
		(SELECT '/usr/bin/pnmsmooth is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmsplit is executable
		(SELECT '/usr/bin/pnmsplit is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtile is executable
		(SELECT '/usr/bin/pnmtile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoddif is executable
		(SELECT '/usr/bin/pnmtoddif is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtofiasco is executable
		(SELECT '/usr/bin/pnmtofiasco is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtofits is executable
		(SELECT '/usr/bin/pnmtofits is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtojpeg is executable
		(SELECT '/usr/bin/pnmtojpeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtopalm is executable
		(SELECT '/usr/bin/pnmtopalm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoplainpnm is executable
		(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtopng is executable
		(SELECT '/usr/bin/pnmtopng is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtops is executable
		(SELECT '/usr/bin/pnmtops is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtorast is executable
		(SELECT '/usr/bin/pnmtorast is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtorle is executable
		(SELECT '/usr/bin/pnmtorle is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtosgi is executable
		(SELECT '/usr/bin/pnmtosgi is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtosir is executable
		(SELECT '/usr/bin/pnmtosir is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtotiff is executable
		(SELECT '/usr/bin/pnmtotiff is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtotiffcmyk is executable
		(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoxwd is executable
		(SELECT '/usr/bin/pnmtoxwd is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppm3d is executable
		(SELECT '/usr/bin/ppm3d is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmbrighten is executable
		(SELECT '/usr/bin/ppmbrighten is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmchange is executable
		(SELECT '/usr/bin/ppmchange is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcie is executable
		(SELECT '/usr/bin/ppmcie is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcolormask is executable
		(SELECT '/usr/bin/ppmcolormask is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcolors is executable
		(SELECT '/usr/bin/ppmcolors is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdim is executable
		(SELECT '/usr/bin/ppmdim is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdist is executable
		(SELECT '/usr/bin/ppmdist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdither is executable
		(SELECT '/usr/bin/ppmdither is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmflash is executable
		(SELECT '/usr/bin/ppmflash is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmforge is executable
		(SELECT '/usr/bin/ppmforge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmhist is executable
		(SELECT '/usr/bin/ppmhist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmlabel is executable
		(SELECT '/usr/bin/ppmlabel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmmake is executable
		(SELECT '/usr/bin/ppmmake is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmmix is executable
		(SELECT '/usr/bin/ppmmix is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmnorm is executable
		(SELECT '/usr/bin/ppmnorm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmntsc is executable
		(SELECT '/usr/bin/ppmntsc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmpat is executable
		(SELECT '/usr/bin/ppmpat is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmquant is executable
		(SELECT '/usr/bin/ppmquant is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmqvga is executable
		(SELECT '/usr/bin/ppmqvga is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmrelief is executable
		(SELECT '/usr/bin/ppmrelief is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmshift is executable
		(SELECT '/usr/bin/ppmshift is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmspread is executable
		(SELECT '/usr/bin/ppmspread is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoacad is executable
		(SELECT '/usr/bin/ppmtoacad is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtobmp is executable
		(SELECT '/usr/bin/ppmtobmp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoeyuv is executable
		(SELECT '/usr/bin/ppmtoeyuv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtogif is executable
		(SELECT '/usr/bin/ppmtogif is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoicr is executable
		(SELECT '/usr/bin/ppmtoicr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoilbm is executable
		(SELECT '/usr/bin/ppmtoilbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtojpeg is executable
		(SELECT '/usr/bin/ppmtojpeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoleaf is executable
		(SELECT '/usr/bin/ppmtoleaf is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtolj is executable
		(SELECT '/usr/bin/ppmtolj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtomitsu is executable
		(SELECT '/usr/bin/ppmtomitsu is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtompeg is executable
		(SELECT '/usr/bin/ppmtompeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoneo is executable
		(SELECT '/usr/bin/ppmtoneo is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopcx is executable
		(SELECT '/usr/bin/ppmtopcx is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopgm is executable
		(SELECT '/usr/bin/ppmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopi1 is executable
		(SELECT '/usr/bin/ppmtopi1 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopict is executable
		(SELECT '/usr/bin/ppmtopict is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopj is executable
		(SELECT '/usr/bin/ppmtopj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopjxl is executable
		(SELECT '/usr/bin/ppmtopjxl is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopuzz is executable
		(SELECT '/usr/bin/ppmtopuzz is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtorgb3 is executable
		(SELECT '/usr/bin/ppmtorgb3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtosixel is executable
		(SELECT '/usr/bin/ppmtosixel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtotga is executable
		(SELECT '/usr/bin/ppmtotga is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtouil is executable
		(SELECT '/usr/bin/ppmtouil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtowinicon is executable
		(SELECT '/usr/bin/ppmtowinicon is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoxpm is executable
		(SELECT '/usr/bin/ppmtoxpm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoyuv is executable
		(SELECT '/usr/bin/ppmtoyuv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoyuvsplit is executable
		(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtv is executable
		(SELECT '/usr/bin/ppmtv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/psidtopgm is executable
		(SELECT '/usr/bin/psidtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pstopnm is executable
		(SELECT '/usr/bin/pstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/qrttoppm is executable
		(SELECT '/usr/bin/qrttoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rasttopnm is executable
		(SELECT '/usr/bin/rasttopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rawtopgm is executable
		(SELECT '/usr/bin/rawtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rawtoppm is executable
		(SELECT '/usr/bin/rawtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rgb3toppm is executable
		(SELECT '/usr/bin/rgb3toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rletopnm is executable
		(SELECT '/usr/bin/rletopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sbigtopgm is executable
		(SELECT '/usr/bin/sbigtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sgitopnm is executable
		(SELECT '/usr/bin/sgitopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sirtopnm is executable
		(SELECT '/usr/bin/sirtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sldtoppm is executable
		(SELECT '/usr/bin/sldtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/spctoppm is executable
		(SELECT '/usr/bin/spctoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/spottopgm is executable
		(SELECT '/usr/bin/spottopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sputoppm is executable
		(SELECT '/usr/bin/sputoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tgatoppm is executable
		(SELECT '/usr/bin/tgatoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/thinkjettopbm is executable
		(SELECT '/usr/bin/thinkjettopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tifftopnm is executable
		(SELECT '/usr/bin/tifftopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/wbmptopbm is executable
		(SELECT '/usr/bin/wbmptopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/winicontoppm is executable
		(SELECT '/usr/bin/winicontoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xbmtopbm is executable
		(SELECT '/usr/bin/xbmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ximtoppm is executable
		(SELECT '/usr/bin/ximtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xpmtoppm is executable
		(SELECT '/usr/bin/xpmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xvminitoppm is executable
		(SELECT '/usr/bin/xvminitoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xwdtopnm is executable
		(SELECT '/usr/bin/xwdtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ybmtopbm is executable
		(SELECT '/usr/bin/ybmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/yuvsplittoppm is executable
		(SELECT '/usr/bin/yuvsplittoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/yuvtoppm is executable
		(SELECT '/usr/bin/yuvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/zeisstopnm is executable
		(SELECT '/usr/bin/zeisstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

