--
-- OVAL-id: OVAL775
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0903' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- MDAC 2.8 (RTM) is installed

	(SELECT 'MDAC 2.8 (RTM) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.8%')

AND EXISTS

	-- the version of odbcbcp.dll is less than 2000.85.1025.0

	(SELECT 'the version of odbcbcp.dll is less than 2000.85.1025.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 85 OR (Version2 = 85 AND
		(Version3 < 1025 OR Version3 = 1025 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlsrv32.dll is less than 2000.85.1025.0

	(SELECT 'the version of sqlsrv32.dll is less than 2000.85.1025.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 85 OR (Version2 = 85 AND
		(Version3 < 1025 OR Version3 = 1025 AND
		Version4 < 0))))))

AND EXISTS

	-- the patch q832483 is not installed
	(SELECT 'the patch q832483 is not installed' FROM Placeholder WHERE

	EXISTS
		-- 32-bit edition of windows and patch q832483 is not installed
		(SELECT '32-bit edition of windows and patch q832483 is not installed' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND NOT EXISTS
			-- the patch q832483 is installed

			(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q832483' AND
				EntryName = 'IsInstalled' AND
				EntryValue = '1'))

	OR EXISTS
		-- 64-bit edition of windows and patch q832483 is not installed
		(SELECT '64-bit edition of windows and patch q832483 is not installed' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND NOT EXISTS
			-- the patch q832483 is installed

			(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB832483' AND
				EntryName = 'Installed' AND
				EntryValue = '1')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

