--
-- OVAL-id: OVAL70
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0803' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File dtspcd exists

	(SELECT 'File dtspcd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/dtspcd')

AND NOT EXISTS

	-- Patch 108949-07 or later installed

	(SELECT 'Patch 108949-07 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108949' AND
		PatchVersion >= '7')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains dtspcd

	(SELECT 'inetd.conf contains dtspcd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/dtspcd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File dtspcd executable
	(SELECT 'File dtspcd executable' FROM Placeholder WHERE

	EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			UEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			GEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

