--
-- OVAL-id: OVAL69
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0356' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

