--
-- OVAL-id: OVAL6788
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0206' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- 64-Bit version of Windows is installed

	(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
		EntryName = 'PROCESSOR_ARCHITECTURE' AND
		EntryValue = 'ia64')

AND EXISTS

	-- a vulnerable version of netdde.exe exists
	(SELECT 'a vulnerable version of netdde.exe exists' FROM Placeholder WHERE

	EXISTS
		-- the version of netdde.exe is less than 5.2.3790.184

		(SELECT 'the version of netdde.exe is less than 5.2.3790.184' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\inetsrv\netdde.exe' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 184))))))

	OR EXISTS
		-- the 64-bit WOW version of netdde.exe is less than 5.2.3790.193

		(SELECT 'the 64-bit WOW version of netdde.exe is less than 5.2.3790.193' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\SysWOW64\netdde.exe' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 193)))))))

AND EXISTS

	-- a vulnerable version of nddenb32.dll exists
	(SELECT 'a vulnerable version of nddenb32.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of nddenb32.dll is less than 5.2.3790.173

		(SELECT 'the version of nddenb32.dll is less than 5.2.3790.173' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\inetsrv\nddenb32.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 173))))))

	OR EXISTS
		-- the 64-bit WOW version of nddenb32.dll is less than 5.2.3790.193

		(SELECT 'the 64-bit WOW version of nddenb32.dll is less than 5.2.3790.193' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\SysWOW64\nddenb32.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 193)))))))

AND NOT EXISTS

	-- the patch KB841533 is installed

	(SELECT 'the patch KB841533 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841533' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

