--
-- OVAL-id: OVAL667
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0251' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ypserv version is less than 2.8-0.9E

	(SELECT 'ypserv version is less than 2.8-0.9E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ypserv' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.8' AND
		RPMTestedRelease = '0.9E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ypserv is listening on the network

	(SELECT 'ypserv is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%ypserv%')

--
-- ### END VULNERABLE CONFIGURATION
;

