--
-- OVAL-id: OVAL65
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File kcms_configure exists

	(SELECT 'File kcms_configure exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_configure')

AND NOT EXISTS

	-- Patch 107337-02 or later installed

	(SELECT 'Patch 107337-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107337' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File kcms_configure executable and SUID or SGID
	(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_configure executable and SUID or SGID

		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_configure' AND
			OEXEC = '1')

	AND EXISTS
		-- File kcms_configure executable and SUID or SGID
		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

		EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SUID = '1')

		OR EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SGID = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

