--
-- OVAL-id: OVAL62
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0797' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File mibiisa exists

	(SELECT 'File mibiisa exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/mibiisa')

AND NOT EXISTS

	-- Patch 107709-19 or later installed

	(SELECT 'Patch 107709-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107709' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mibiisa running

	(SELECT 'mibiisa running' FROM Solaris_PSInfo WHERE
		Command LIKE '%mibiisa%')

--
-- ### END VULNERABLE CONFIGURATION
;

