--
-- OVAL-id: OVAL606
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0824' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- the version of shtml.dll is less than 4.0.2.7523

	(SELECT 'the version of shtml.dll is less than 4.0.2.7523' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\isapi\shtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'CommonFilesDir') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 02 OR Version3 = 02 AND
		Version4 < 7523))))))

AND NOT EXISTS

	-- the patch q810217 is installed (Hotfix key)

	(SELECT 'the patch q810217 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB810217' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (2K, XP)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (2K, XP)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Setup\OC Manager\Subcomponents' AND
		EntryName = 'fp_extensions' AND
		EntryValue = '1')

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

