--
-- OVAL-id: OVAL595
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0681' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sendmail version is less than 8.12.8-9.90

	(SELECT 'sendmail version is less than 8.12.8-9.90' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sendmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '8.12.8' AND
		RPMTestedRelease = '9.90' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- sendmail is Set-UID
		(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SUID = '1')

		AND EXISTS
			-- sendmail is Set-UID
			(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

			EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					GEXEC = '1')

			OR EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					OEXEC = '1')))

	OR EXISTS
		-- sendmail is Set-GID
		(SELECT 'sendmail is Set-GID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-GID

			(SELECT 'sendmail is Set-GID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SGID = '1')

		AND EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				OEXEC = '1'))

	OR EXISTS
		-- sendmail listening

		(SELECT 'sendmail listening' FROM RedHat_InetListeningServers WHERE
			ProgramName LIKE '%sendmail%' AND
			Protocol = 'TCP'))

--
-- ### END VULNERABLE CONFIGURATION
;

