--
-- OVAL-id: OVAL5926
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0574' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 Server is installed
	(SELECT 'Windows 2000 Server is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Windows server product option
		(SELECT 'Windows server product option' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Server (stand-alone)

			(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%ServerNT%')

		OR EXISTS
			-- this is an NT Server (domain controller)

			(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%LanmanNT%')))

AND EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

AND EXISTS

	-- the version of nntpsvc.dll is less than 5.0.2195.6972

	(SELECT 'the version of nntpsvc.dll is less than 5.0.2195.6972' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\nntpsvc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6972))))))

AND NOT EXISTS

	-- Patch Windows2000-KB883935-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB883935-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB883935' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the NNTP service is enabled

	(SELECT 'the NNTP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NntpSvc' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

