--
-- OVAL-id: OVAL59
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-1561' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6106

	(SELECT 'File %windir%\system32\rpcrt4.dll version is less than 5.0.2195.6106' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\rpcrt4.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6106))))))

AND NOT EXISTS

	-- Patch Q331953_W2K_SP4_X86_EN.exe Installed

	(SELECT 'Patch Q331953_W2K_SP4_X86_EN.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\Q331953' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Windows2000-KB823980-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB823980-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823980' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

