--
-- OVAL-id: OVAL56
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0779' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.yppasswdd exists

	(SELECT 'File rpc.yppasswdd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rpc.yppasswdd')

AND NOT EXISTS

	-- Patch 111596-02 or later installed

	(SELECT 'Patch 111596-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111596' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.yppasswdd running

	(SELECT 'rpc.yppasswdd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%rpc.yppasswdd%')

--
-- ### END VULNERABLE CONFIGURATION
;

