--
-- OVAL-id: OVAL544
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0540' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- postfix version is less than 1.1.12-1

	(SELECT 'postfix version is less than 1.1.12-1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'postfix' AND
		RPMTestedEpoch = '2' AND
		RPMTestedVersion = '1.1.12' AND
		RPMTestedRelease = '1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smtpd listens on the network

	(SELECT 'smtpd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smtpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

