--
-- OVAL-id: OVAL531
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.5 Service Pack 2 is installed

	(SELECT 'Internet Explorer 5.5 Service Pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.50.4807.2300')

AND EXISTS

	-- the version of mshtml.dll is less than 5.50.4937.800

	(SELECT 'the version of mshtml.dll is less than 5.50.4937.800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 50 OR (Version2 = 50 AND
		(Version3 < 4937 OR Version3 = 4937 AND
		Version4 < 800))))))

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

