--
-- OVAL-id: OVAL52
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0165' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- eog version is less than 2.2.0-2

	(SELECT 'eog version is less than 2.2.0-2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'eog' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.2.0' AND
		RPMTestedRelease = '2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- eog is executable
	(SELECT 'eog is executable' FROM Placeholder WHERE

	EXISTS
		-- eog is world-executable

		(SELECT 'eog is world-executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/eog' AND
			OEXEC = '1')

	OR EXISTS
		-- eog is group-executable

		(SELECT 'eog is group-executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/eog' AND
			GEXEC = '1')

	OR EXISTS
		-- eog is owner-executable

		(SELECT 'eog is owner-executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/eog' AND
			UEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

