--
-- OVAL-id: OVAL5074
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0206' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND EXISTS

	-- 32-Bit version of Windows is installed

	(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
		EntryName = 'PROCESSOR_ARCHITECTURE' AND
		EntryValue = 'x86')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

AND EXISTS

	-- a vulnerable version of nddenb32.dll exists
	(SELECT 'a vulnerable version of nddenb32.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and a vulnerable version of nddenb32.dll exists
		(SELECT 'no service pack is installed and a vulnerable version of nddenb32.dll exists' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of nddenb32.dll is less than 5.1.2600.149

			(SELECT 'the version of nddenb32.dll is less than 5.1.2600.149' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\inetsrv\nddenb32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 149)))))))

	OR EXISTS
		-- Service Pack 1 is installed and a vulnerable version of nddenb32.dll exists
		(SELECT 'Service Pack 1 is installed and a vulnerable version of nddenb32.dll exists' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of nddenb32.dll is less than 5.1.2600.1555

			(SELECT 'the version of nddenb32.dll is less than 5.1.2600.1555' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\inetsrv\nddenb32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1555))))))))

AND EXISTS

	-- a vulnerable version of netdde.exe exists
	(SELECT 'a vulnerable version of netdde.exe exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and a vulnerable version of netdde.exe exists
		(SELECT 'no service pack is installed and a vulnerable version of netdde.exe exists' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of netdde.exe is less than 5.1.2600.158

			(SELECT 'the version of netdde.exe is less than 5.1.2600.158' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\inetsrv\netdde.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 158)))))))

	OR EXISTS
		-- Service Pack 1 is installed and a vulnerable version of netdde.exe exists
		(SELECT 'Service Pack 1 is installed and a vulnerable version of netdde.exe exists' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of netdde.exe is less than 5.1.2600.1567

			(SELECT 'the version of netdde.exe is less than 5.1.2600.1567' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\inetsrv\netdde.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1567))))))))

AND NOT EXISTS

	-- the patch KB841533 is installed

	(SELECT 'the patch KB841533 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841533' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

