--
-- OVAL-id: OVAL483
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0224' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\ssinc.dll version is less than 5.0.2195.6624

	(SELECT 'File %windir%\system32\inetsrv\ssinc.dll version is less than 5.0.2195.6624' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\ssinc.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6624))))))

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SmartHTML interpreter is enabled

	(SELECT 'SmartHTML interpreter is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6014' AND
		Data LIKE '%ssinc.dll%')

--
-- ### END VULNERABLE CONFIGURATION
;

